/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.rest;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.console.Console;
import org.structr.console.rest.RestCommand;
import org.structr.util.Writable;

public class HelpRestCommand
extends RestCommand {
    private String subCommand = null;

    @Override
    public void run(Console console, Writable writable) throws FrameworkException, IOException {
        if (this.subCommand != null) {
            RestCommand cmd = RestCommand.getCommand(this.subCommand);
            if (this.subCommand != null) {
                cmd.detailHelp(writable);
            } else {
                writable.println(new Object[]{"Unknown command '" + this.subCommand + "'."});
            }
        } else {
            for (String key : RestCommand.commandNames()) {
                RestCommand cmd = RestCommand.getCommand(key);
                writable.print(new Object[]{StringUtils.rightPad((String)key, (int)10)});
                writable.print(new Object[]{" - "});
                cmd.commandHelp(writable);
            }
        }
    }

    @Override
    public boolean parseNext(String line, Writable writable) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)line)) {
            this.subCommand = StringUtils.substringBefore((String)line, (String)" ").trim();
        }
        return true;
    }

    @Override
    public void commandHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"Prints a list of all commands and a short help text. Use 'help <command> to get more details."});
    }

    @Override
    public void detailHelp(Writable writable) throws IOException {
        this.commandHelp(writable);
    }

    static {
        RestCommand.registerCommand("help", HelpRestCommand.class);
    }
}

