/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis;

import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.MutableDocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableFolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableRelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableSecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.server.support.TypeDefinitionFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cmis.CMISInfo;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.SchemaNode;
import org.structr.core.graph.search.SearchCommand;
import org.structr.core.property.PropertyKey;
import org.structr.dynamic.File;
import org.structr.files.cmis.AbstractStructrCmisService;
import org.structr.files.cmis.StructrCMISService;
import org.structr.files.cmis.config.StructrRepositoryInfo;
import org.structr.files.cmis.wrapper.CMISTypeDefinitionListWrapper;
import org.structr.schema.ConfigurationProvider;
import org.structr.web.entity.Folder;

public class CMISRepositoryService
extends AbstractStructrCmisService
implements RepositoryService {
    private static final Logger logger = LoggerFactory.getLogger((String)CMISRepositoryService.class.getName());
    private final RepositoryInfo repositoryInfo = new StructrRepositoryInfo();

    public CMISRepositoryService(StructrCMISService parentService, SecurityContext securityContext) {
        super(parentService, securityContext);
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        LinkedList<RepositoryInfo> infoList = new LinkedList<RepositoryInfo>();
        infoList.add(this.repositoryInfo);
        return infoList;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        if (repositoryId != null && repositoryId.equals(this.repositoryInfo.getId())) {
            return this.repositoryInfo;
        }
        throw new CmisObjectNotFoundException(repositoryId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        CMISTypeDefinitionListWrapper results = new CMISTypeDefinitionListWrapper(maxItems, skipCount);
        if (typeId != null) {
            BaseTypeId baseTypeId = this.getBaseTypeId(typeId);
            if (baseTypeId != null) {
                results.addAll(this.getBaseTypeChildren(baseTypeId, includePropertyDefinitions));
                return results;
            } else {
                Class type = StructrApp.getConfiguration().getNodeEntityClass(typeId);
                if (type == null) throw new CmisObjectNotFoundException("Type with ID " + typeId + " does not exist");
                results.addAll(this.getTypeChildren(typeId, includePropertyDefinitions));
            }
            return results;
        } else {
            results.add(this.getDocumentTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value(), includePropertyDefinitions, true));
            results.add(this.getFolderTypeDefinition(BaseTypeId.CMIS_FOLDER.value(), includePropertyDefinitions, true));
            results.add(this.getItemTypeDefinition(BaseTypeId.CMIS_ITEM.value(), includePropertyDefinitions, true));
            results.add(this.getPolicyTypeDefinition(BaseTypeId.CMIS_POLICY.value(), includePropertyDefinitions, true));
            results.add(this.getRelationshipTypeDefinition(BaseTypeId.CMIS_RELATIONSHIP.value(), includePropertyDefinitions, true));
            results.add(this.getSecondaryTypeDefinition(BaseTypeId.CMIS_SECONDARY.value(), includePropertyDefinitions, true));
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        LinkedList<TypeDefinitionContainer> results = new LinkedList<TypeDefinitionContainer>();
        if (typeId != null) {
            BaseTypeId baseTypeId = this.getBaseTypeId(typeId);
            if (baseTypeId != null) {
                TypeDefinition typeDefinition = this.getTypeDefinition(repositoryId, typeId, extension);
                TypeDefinitionContainer container = this.getTypeDefinitionContainer(typeDefinition, includePropertyDefinitions);
                results.add(container);
                return results;
            } else {
                Class type = StructrApp.getConfiguration().getNodeEntityClass(typeId);
                if (type == null) throw new CmisObjectNotFoundException("Type with ID " + typeId + " does not exist");
                MutableTypeDefinition typeDefinition = this.extendTypeDefinition(type, includePropertyDefinitions);
                if (typeDefinition == null) throw new CmisObjectNotFoundException("Type with ID " + typeId + " does not exist");
                results.add(this.getTypeDefinitionContainer((TypeDefinition)typeDefinition, includePropertyDefinitions));
            }
            return results;
        } else {
            results.add(this.getTypeDefinitionContainer((TypeDefinition)this.getDocumentTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value(), includePropertyDefinitions, true), includePropertyDefinitions));
            results.add(this.getTypeDefinitionContainer((TypeDefinition)this.getFolderTypeDefinition(BaseTypeId.CMIS_FOLDER.value(), includePropertyDefinitions, true), includePropertyDefinitions));
            results.add(this.getTypeDefinitionContainer((TypeDefinition)this.getItemTypeDefinition(BaseTypeId.CMIS_ITEM.value(), includePropertyDefinitions, true), includePropertyDefinitions));
            results.add(this.getTypeDefinitionContainer((TypeDefinition)this.getPolicyTypeDefinition(BaseTypeId.CMIS_POLICY.value(), includePropertyDefinitions, true), includePropertyDefinitions));
            results.add(this.getTypeDefinitionContainer((TypeDefinition)this.getRelationshipTypeDefinition(BaseTypeId.CMIS_RELATIONSHIP.value(), includePropertyDefinitions, true), includePropertyDefinitions));
            results.add(this.getTypeDefinitionContainer((TypeDefinition)this.getSecondaryTypeDefinition(BaseTypeId.CMIS_SECONDARY.value(), includePropertyDefinitions, true), includePropertyDefinitions));
        }
        return results;
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        MutableTypeDefinition extendedTypeDefinition;
        switch (typeId) {
            case "cmis:document": {
                return this.getDocumentTypeDefinition(typeId, true, true);
            }
            case "cmis:folder": {
                return this.getFolderTypeDefinition(typeId, true, true);
            }
            case "cmis:item": {
                return this.getItemTypeDefinition(typeId, true, true);
            }
            case "cmis:policy": {
                return this.getPolicyTypeDefinition(typeId, true, true);
            }
            case "cmis:relationship": {
                return this.getRelationshipTypeDefinition(typeId, true, true);
            }
            case "cmis:secondary": {
                return this.getSecondaryTypeDefinition(typeId, true, true);
            }
        }
        Class type = StructrApp.getConfiguration().getNodeEntityClass(typeId);
        if (type != null && (extendedTypeDefinition = this.extendTypeDefinition(type, true)) != null) {
            return extendedTypeDefinition;
        }
        throw new CmisObjectNotFoundException("Type with ID " + typeId + " does not exist");
    }

    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        return null;
    }

    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        return null;
    }

    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
    }

    private MutableSecondaryTypeDefinition getSecondaryTypeDefinition(String typeId, boolean includePropertyDefinitions, boolean baseType) {
        TypeDefinitionFactory factory = TypeDefinitionFactory.newInstance();
        MutableSecondaryTypeDefinition def = factory.createSecondaryTypeDefinition(CmisVersion.CMIS_1_1, baseType ? null : BaseTypeId.CMIS_SECONDARY.value());
        def.setIsCreatable(Boolean.valueOf(false));
        this.initializeExtendedType((MutableTypeDefinition)def, typeId);
        if (!includePropertyDefinitions) {
            def.removeAllPropertyDefinitions();
        }
        return def;
    }

    private MutableRelationshipTypeDefinition getRelationshipTypeDefinition(String typeId, boolean includePropertyDefinitions, boolean baseType) {
        TypeDefinitionFactory factory = TypeDefinitionFactory.newInstance();
        MutableRelationshipTypeDefinition def = factory.createRelationshipTypeDefinition(CmisVersion.CMIS_1_1, baseType ? null : BaseTypeId.CMIS_RELATIONSHIP.value());
        def.setIsCreatable(Boolean.valueOf(false));
        this.initializeExtendedType((MutableTypeDefinition)def, typeId);
        if (!includePropertyDefinitions) {
            def.removeAllPropertyDefinitions();
        }
        return def;
    }

    private MutableItemTypeDefinition getItemTypeDefinition(String typeId, boolean includePropertyDefinitions, boolean baseType) {
        TypeDefinitionFactory factory = TypeDefinitionFactory.newInstance();
        MutableItemTypeDefinition def = factory.createItemTypeDefinition(CmisVersion.CMIS_1_1, baseType ? null : BaseTypeId.CMIS_ITEM.value());
        def.setIsCreatable(Boolean.valueOf(false));
        this.initializeExtendedType((MutableTypeDefinition)def, typeId);
        if (!includePropertyDefinitions) {
            def.removeAllPropertyDefinitions();
        }
        return def;
    }

    private MutablePolicyTypeDefinition getPolicyTypeDefinition(String typeId, boolean includePropertyDefinitions, boolean baseType) {
        TypeDefinitionFactory factory = TypeDefinitionFactory.newInstance();
        MutablePolicyTypeDefinition def = factory.createPolicyTypeDefinition(CmisVersion.CMIS_1_1, baseType ? null : BaseTypeId.CMIS_POLICY.value());
        def.setIsCreatable(Boolean.valueOf(false));
        this.initializeExtendedType((MutableTypeDefinition)def, typeId);
        if (!includePropertyDefinitions) {
            def.removeAllPropertyDefinitions();
        }
        return def;
    }

    private MutableFolderTypeDefinition getFolderTypeDefinition(String typeId, boolean includePropertyDefinitions, boolean baseType) {
        TypeDefinitionFactory factory = TypeDefinitionFactory.newInstance();
        MutableFolderTypeDefinition def = factory.createFolderTypeDefinition(CmisVersion.CMIS_1_1, baseType ? null : BaseTypeId.CMIS_FOLDER.value());
        this.initializeExtendedType((MutableTypeDefinition)def, typeId);
        if (!includePropertyDefinitions) {
            def.removeAllPropertyDefinitions();
        }
        return def;
    }

    private MutableDocumentTypeDefinition getDocumentTypeDefinition(String typeId, boolean includePropertyDefinitions, boolean baseType) {
        TypeDefinitionFactory factory = TypeDefinitionFactory.newInstance();
        MutableDocumentTypeDefinition def = factory.createDocumentTypeDefinition(CmisVersion.CMIS_1_1, baseType ? null : BaseTypeId.CMIS_DOCUMENT.value());
        def.setContentStreamAllowed(ContentStreamAllowed.REQUIRED);
        this.initializeExtendedType((MutableTypeDefinition)def, typeId);
        if (!includePropertyDefinitions) {
            def.removeAllPropertyDefinitions();
        }
        return def;
    }

    private List<TypeDefinition> getTypeChildren(String typeId, Boolean includePropertyDefinitions) {
        LinkedHashSet subtypes = new LinkedHashSet(SearchCommand.getAllSubtypesAsStringSet((String)typeId));
        ConfigurationProvider config = StructrApp.getConfiguration();
        LinkedList<TypeDefinition> result = new LinkedList<TypeDefinition>();
        subtypes.remove(typeId);
        for (String subtype : subtypes) {
            MutableTypeDefinition extendedTypeDefinition;
            Class subclass = config.getNodeEntityClass(subtype);
            if (subclass == null || (extendedTypeDefinition = this.extendTypeDefinition(subclass, includePropertyDefinitions)) == null) continue;
            result.add((TypeDefinition)extendedTypeDefinition);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private List<TypeDefinition> getBaseTypeChildren(BaseTypeId baseTypeId, Boolean includePropertyDefinitions) {
        config = StructrApp.getConfiguration();
        result = new LinkedList<TypeDefinition>();
        app = StructrApp.getInstance();
        switch (1.$SwitchMap$org$apache$chemistry$opencmis$commons$enums$BaseTypeId[baseTypeId.ordinal()]) {
            case 1: {
                result.add((TypeDefinition)this.extendTypeDefinition(File.class, includePropertyDefinitions));
                break;
            }
            case 2: {
                result.add((TypeDefinition)this.extendTypeDefinition(Folder.class, includePropertyDefinitions));
                break;
            }
            case 3: {
                try {
                    tx = app.tx();
                    var7_8 = null;
                    for (SchemaNode schemaNode : app.nodeQuery(SchemaNode.class).sort((PropertyKey)AbstractNode.name).getAsList()) {
                        type = config.getNodeEntityClass(schemaNode.getClassName());
                        if (type == null || (info = this.getCMISInfo(type)) == null || !baseTypeId.equals((Object)info.getBaseTypeId()) || (extendedTypeDefinition = this.extendTypeDefinition(type, includePropertyDefinitions)) == null) continue;
                        result.add((TypeDefinition)extendedTypeDefinition);
                    }
                    tx.success();
                    if (tx == null) break;
                    if (var7_8 == null) ** GOTO lbl33
                    try {
                        tx.close();
                    }
                    catch (Throwable var8_10) {
                        var7_8.addSuppressed(var8_10);
                    }
                    break;
lbl33:
                    // 1 sources

                    tx.close();
                    ** break;
                    catch (Throwable var8_11) {
                        try {
                            var7_8 = var8_11;
                            throw var8_11;
                        }
                        catch (Throwable var13_16) {
                            if (tx != null) {
                                if (var7_8 != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable var14_17) {
                                        var7_8.addSuppressed(var14_17);
                                    }
                                } else {
                                    tx.close();
                                }
                            }
                            throw var13_16;
lbl50:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (FrameworkException fex) {
                    CMISRepositoryService.logger.warn("", (Throwable)fex);
                }
            }
        }
        return result;
    }

    private TypeDefinitionContainer getTypeDefinitionContainer(TypeDefinition typeDefinition, Boolean includePropertyDefinitions) {
        TypeDefinitionContainerImpl result = new TypeDefinitionContainerImpl();
        LinkedList<TypeDefinitionContainer> list = new LinkedList<TypeDefinitionContainer>();
        result.setTypeDefinition(typeDefinition);
        result.setChildren(list);
        String typeId = typeDefinition.getId();
        BaseTypeId baseTypeId = this.getBaseTypeId(typeId);
        if (baseTypeId != null) {
            for (TypeDefinition child : this.getBaseTypeChildren(baseTypeId, includePropertyDefinitions)) {
                list.add(this.getTypeDefinitionContainer(child, includePropertyDefinitions));
            }
        } else {
            for (TypeDefinition child : this.getTypeChildren(typeDefinition.getId(), includePropertyDefinitions)) {
                list.add(this.getTypeDefinitionContainer(child, includePropertyDefinitions));
            }
        }
        return result;
    }

    private MutableTypeDefinition extendTypeDefinition(Class<? extends GraphObject> type, Boolean includePropertyDefinitions) {
        String typeName = type.getSimpleName();
        MutableDocumentTypeDefinition result = null;
        try {
            BaseTypeId baseTypeId;
            CMISInfo info;
            GraphObject obj = type.newInstance();
            if (obj != null && (info = obj.getCMISInfo()) != null && (baseTypeId = info.getBaseTypeId()) != null) {
                switch (baseTypeId) {
                    case CMIS_DOCUMENT: {
                        result = this.getDocumentTypeDefinition(typeName, includePropertyDefinitions, false);
                        break;
                    }
                    case CMIS_FOLDER: {
                        result = this.getFolderTypeDefinition(typeName, includePropertyDefinitions, false);
                        break;
                    }
                    case CMIS_ITEM: {
                        result = this.getItemTypeDefinition(typeName, includePropertyDefinitions, false);
                        break;
                    }
                    case CMIS_POLICY: {
                        result = this.getPolicyTypeDefinition(typeName, includePropertyDefinitions, false);
                        break;
                    }
                    case CMIS_RELATIONSHIP: {
                        result = this.getRelationshipTypeDefinition(typeName, includePropertyDefinitions, false);
                        break;
                    }
                    case CMIS_SECONDARY: {
                        result = this.getSecondaryTypeDefinition(typeName, includePropertyDefinitions, false);
                    }
                }
                if (result != null) {
                    for (PropertyKey key : StructrApp.getConfiguration().getPropertySet(type, "all")) {
                        MutablePropertyDefinition property = this.createProperty(type, key);
                        if (property == null) continue;
                        result.addPropertyDefinition((PropertyDefinition)property);
                    }
                }
            }
        }
        catch (IllegalAccessException | InstantiationException iex) {
            logger.warn("", (Throwable)iex);
        }
        return result;
    }

    private void initializeExtendedType(MutableTypeDefinition type, String typeId) {
        type.setId(typeId);
        type.setLocalName(typeId);
        type.setQueryName(typeId);
        type.setDisplayName(typeId);
        type.setDescription(typeId);
    }

    private MutablePropertyDefinition createProperty(Class type, PropertyKey key) {
        if (key.isDynamic() || key.isCMISProperty()) {
            TypeDefinitionFactory factory = TypeDefinitionFactory.newInstance();
            PropertyType dataType = key.getDataType();
            if (dataType != null) {
                String propertyId;
                String displayName = propertyId = key.jsonName();
                String description = StringUtils.capitalize((String)propertyId);
                Class declaringClass = key.getDeclaringClass();
                boolean isInherited = !type.getSimpleName().equals(declaringClass.getSimpleName());
                Cardinality cardinality = Cardinality.SINGLE;
                Updatability updatability = Updatability.READWRITE;
                boolean required = key.isNotNull();
                boolean queryable = key.isIndexed();
                boolean orderable = key.isIndexed();
                MutablePropertyDefinition property = factory.createPropertyDefinition(propertyId, displayName, description, dataType, cardinality, updatability, isInherited, required, queryable, orderable);
                Class valueType = key.valueType();
                if (valueType != null && valueType.isEnum()) {
                    LinkedList<Choice> choices = new LinkedList<Choice>();
                    for (Object option : valueType.getEnumConstants()) {
                        String optionName = option.toString();
                        choices.add(factory.createChoice(optionName, (Object)optionName));
                    }
                    property.setIsOpenChoice(Boolean.valueOf(false));
                    property.setChoices(choices);
                }
                return property;
            }
        }
        return null;
    }
}

