/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis.wrapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.structr.cmis.common.CMISExtensionsData;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.FileBase;

public class CMISContentStream
extends CMISExtensionsData
implements ContentStream {
    private String contentType = null;
    private String name = null;
    private long length = 0L;
    private File file = null;
    private long offset = 0L;

    public CMISContentStream(FileBase file, BigInteger offset, BigInteger length) {
        this.contentType = (String)file.getProperty((PropertyKey)FileBase.contentType);
        this.name = file.getName();
        this.file = file.getFileOnDisk();
        this.offset = offset != null ? offset.longValue() : 0L;
        this.length = length != null ? length.longValue() : file.getSize().longValue();
    }

    public long getLength() {
        return this.length;
    }

    public BigInteger getBigLength() {
        return BigInteger.valueOf(this.length);
    }

    public String getMimeType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.name;
    }

    public InputStream getStream() {
        try {
            FileChannel channel = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);
            long mappedLength = Math.max(0L, Math.min(channel.size() - this.offset, this.length));
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, this.offset, mappedLength);
            return new MappedInputStream(buffer);
        }
        catch (IOException ioex) {
            throw new CmisConstraintException(ioex.getMessage());
        }
    }

    private class MappedInputStream
    extends InputStream {
        private MappedByteBuffer buffer = null;

        public MappedInputStream(MappedByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int read() throws IOException {
            if (this.buffer.remaining() > 0) {
                return this.buffer.get();
            }
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int length = Math.min(this.buffer.remaining(), len);
            this.buffer.get(b, off, length);
            if (length == 0) {
                return -1;
            }
            return length;
        }

        @Override
        public long skip(long n) throws IOException {
            int currentPosition = Long.valueOf(this.buffer.position()).intValue();
            int skip = Math.min(this.buffer.remaining(), Long.valueOf(n).intValue());
            this.buffer.position(currentPosition + skip);
            return skip;
        }

        @Override
        public int available() throws IOException {
            return this.buffer.remaining();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.buffer.mark();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.buffer.reset();
        }

        @Override
        public boolean markSupported() {
            return true;
        }
    }
}

