/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.SyncCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.resource.MaintenanceParameterResource;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;

public class UiSyncCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)UiSyncCommand.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        String mode = (String)attributes.get("mode");
        if (mode == null) throw new FrameworkException(400, "Please specify mode, must be one of (import|export)");
        String fileName = (String)attributes.get("file");
        if (fileName == null) throw new FrameworkException(400, "Please specify file name using the file parameter.");
        if ("export".equals(mode)) {
            this.doExport(fileName);
        }
        if (!"import".equals(mode)) return;
        this.doImport(fileName);
    }

    public boolean requiresEnclosingTransaction() {
        return false;
    }

    public boolean requiresFlushingOfCaches() {
        return false;
    }

    private void doExport(String fileName) throws FrameworkException {
        LinkedHashSet<RelationshipInterface> rels = new LinkedHashSet<RelationshipInterface>();
        LinkedHashSet<NodeInterface> nodes = new LinkedHashSet<NodeInterface>();
        LinkedHashSet<String> filePaths = new LinkedHashSet<String>();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (Folder folder : app.nodeQuery(Folder.class).and((PropertyKey)Folder.includeInFrontendExport, (Object)true).getAsList()) {
                this.collectDataRecursively(app, (GraphObject)folder, nodes, rels, filePaths);
            }
            for (Page page : app.nodeQuery(Page.class).getAsList()) {
                this.collectDataRecursively(app, (GraphObject)page, nodes, rels, filePaths);
            }
            SyncCommand.exportToFile((String)fileName, nodes, rels, filePaths, (boolean)true);
            tx.success();
        }
    }

    private void doImport(String fileName) throws FrameworkException {
        App app = StructrApp.getInstance();
        DatabaseService graphDb = app.getDatabaseService();
        SyncCommand.importFromFile((DatabaseService)graphDb, (SecurityContext)this.securityContext, (String)fileName, (boolean)true);
        try (Tx tx = app.tx();){
            List shadowDocuments = app.nodeQuery(ShadowDocument.class).includeDeletedAndHidden().getAsList();
            if (shadowDocuments.size() > 1) {
                LinkedList collectiveChildren = new LinkedList();
                Collections.sort(shadowDocuments, new Comparator<ShadowDocument>(){

                    @Override
                    public int compare(ShadowDocument t1, ShadowDocument t2) {
                        return t2.getNodeId().compareTo(t1.getNodeId());
                    }
                });
                ShadowDocument previousShadowDoc = (ShadowDocument)shadowDocuments.get(0);
                ShadowDocument newShadowDoc = (ShadowDocument)shadowDocuments.get(1);
                collectiveChildren.addAll((Collection)previousShadowDoc.getProperty((PropertyKey)Page.elements));
                collectiveChildren.addAll((Collection)newShadowDoc.getProperty((PropertyKey)Page.elements));
                app.delete((NodeInterface)previousShadowDoc);
                newShadowDoc.setProperties(this.securityContext, new PropertyMap(Page.elements, collectiveChildren));
            }
            tx.success();
        }
    }

    private void collectDataRecursively(App app, GraphObject root, Set<NodeInterface> nodes, Set<RelationshipInterface> rels, Set<String> files) throws FrameworkException {
        RelationshipInterface rel;
        if (root.isNode()) {
            NodeInterface node = root.getSyncNode();
            if (node instanceof FileBase) {
                String fileUuid = node.getUuid();
                files.add(fileUuid);
            }
            if (nodes.add(node)) {
                List syncData = node.getSyncData();
                if (syncData != null) {
                    for (GraphObject obj : syncData) {
                        if (obj == null) continue;
                        this.collectDataRecursively(app, obj, nodes, rels, files);
                    }
                } else {
                    logger.warn("Node {} returned null syncData!", (Object)node);
                }
            }
        } else if (root.isRelationship() && rels.add(rel = root.getSyncRelationship())) {
            List syncData = rel.getSyncData();
            if (syncData != null) {
                for (GraphObject obj : syncData) {
                    if (obj == null) continue;
                    this.collectDataRecursively(app, obj, nodes, rels, files);
                }
            } else {
                logger.warn("Relationship {} returned null syncData!", (Object)rel);
            }
        }
    }

    static {
        MaintenanceParameterResource.registerMaintenanceCommand("syncUi", UiSyncCommand.class);
    }
}

