/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.auth;

import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.GitHubTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthAuthzResponse;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.core.entity.Person;
import org.structr.core.property.PropertyKey;
import org.structr.web.auth.FacebookAuthClient;
import org.structr.web.auth.GitHubAuthClient;
import org.structr.web.auth.GoogleAuthClient;
import org.structr.web.auth.LinkedInAuthClient;
import org.structr.web.auth.TwitterAuthClient;

public class StructrOAuthClient {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrOAuthClient.class.getName());
    private static final String CONFIGURED_OAUTH_SERVERS = "oauth.servers";
    protected String authorizationLocation;
    protected String tokenLocation;
    protected String clientId;
    protected String clientSecret;
    protected String redirectUri;
    protected String state;
    protected Class tokenResponseClass;
    private OAuthAccessTokenResponse tokenResponse;
    private OAuthResourceResponse userResponse;

    public StructrOAuthClient() {
    }

    public StructrOAuthClient(String authorizationLocation, String tokenLocation, String clientId, String clientSecret, String redirectUri) {
        this.init(authorizationLocation, tokenLocation, clientId, clientSecret, redirectUri, OAuthJSONAccessTokenResponse.class);
    }

    protected void init(String authorizationLocation, String tokenLocation, String clientId, String clientSecret, String redirectUri, Class tokenResponseClass) {
        this.authorizationLocation = authorizationLocation;
        this.tokenLocation = tokenLocation;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.tokenResponseClass = tokenResponseClass;
    }

    public String toString() {
        return this.getClass().getName() + "\nauthorizationLocation: " + this.authorizationLocation + "\ntokenLocation: " + this.tokenLocation + "\nclientId: " + this.clientId + "\nclientSecret: " + this.clientSecret + "\nredirectUri: " + this.redirectUri + "\nstate: " + this.state;
    }

    public String getEndUserAuthorizationRequestUri(HttpServletRequest request) {
        try {
            OAuthClientRequest oauthClientRequest = OAuthClientRequest.authorizationLocation((String)this.authorizationLocation).setClientId(this.clientId).setRedirectURI(this.getAbsoluteUrl(request, this.redirectUri)).setScope(this.getScope()).setResponseType(this.getResponseType()).setState(this.getState()).buildQueryMessage();
            logger.info("Authorization request location URI: {}", (Object)oauthClientRequest.getLocationUri());
            return oauthClientRequest.getLocationUri();
        }
        catch (OAuthSystemException ex) {
            logger.error("", (Throwable)ex);
            return null;
        }
    }

    public static StructrOAuthClient getServer(String name) {
        String[] authServers;
        String configuredOauthServers = (String)Settings.OAuthServers.getValue();
        for (String authServer : authServers = configuredOauthServers.split(" ")) {
            if (!authServer.equals(name)) continue;
            String authLocation = (String)Settings.getOrCreateStringSetting((String[])new String[]{"oauth", authServer, "authorization_location"}).getValue();
            String tokenLocation = (String)Settings.getOrCreateStringSetting((String[])new String[]{"oauth", authServer, "token_location"}).getValue();
            String clientId = (String)Settings.getOrCreateStringSetting((String[])new String[]{"oauth", authServer, "client_id"}).getValue();
            String clientSecret = (String)Settings.getOrCreateStringSetting((String[])new String[]{"oauth", authServer, "client_secret"}).getValue();
            String redirectUri = (String)Settings.getOrCreateStringSetting((String[])new String[]{"oauth", authServer, "redirect_uri"}).getValue();
            if (clientId == null || clientSecret == null || redirectUri == null) continue;
            Class serverClass = StructrOAuthClient.getServerClassForName(name);
            Class tokenResponseClass = StructrOAuthClient.getTokenResponseClassForName(name);
            try {
                StructrOAuthClient oauthServer = (StructrOAuthClient)serverClass.newInstance();
                oauthServer.init(authLocation, tokenLocation, clientId, clientSecret, redirectUri, tokenResponseClass);
                logger.info("Using OAuth server {}", (Object)oauthServer);
                return oauthServer;
            }
            catch (Throwable t) {
                logger.error("Could not instantiate auth server", t);
            }
        }
        return null;
    }

    private static Class getTokenResponseClassForName(String name) {
        switch (name) {
            case "github": {
                return GitHubTokenResponse.class;
            }
            case "facebook": {
                return GitHubTokenResponse.class;
            }
        }
        return OAuthJSONAccessTokenResponse.class;
    }

    private static Class getServerClassForName(String name) {
        switch (name) {
            case "github": {
                return GitHubAuthClient.class;
            }
            case "twitter": {
                return TwitterAuthClient.class;
            }
            case "facebook": {
                return FacebookAuthClient.class;
            }
            case "linkedin": {
                return LinkedInAuthClient.class;
            }
            case "google": {
                return GoogleAuthClient.class;
            }
        }
        return StructrOAuthClient.class;
    }

    protected GrantType getGrantType() {
        return GrantType.AUTHORIZATION_CODE;
    }

    protected String getScope() {
        return "";
    }

    protected String getResponseType() {
        return "code";
    }

    protected String getState() {
        return "";
    }

    protected String getAccessTokenParameterKey() {
        return "access_token";
    }

    private static String getCode(HttpServletRequest request) {
        try {
            logger.info("Trying to get authorization code from request {}", (Object)request);
            OAuthAuthzResponse oar = OAuthAuthzResponse.oauthCodeAuthzResponse((HttpServletRequest)request);
            String code = oar.getCode();
            logger.info("Got code {} from authorization request", (Object)code);
            return oar.getCode();
        }
        catch (OAuthProblemException e) {
            logger.error("Could not read authorization request: {}, {}", new Object[]{e.getError(), e.getDescription()});
            return null;
        }
    }

    public PropertyKey getCredentialKey() {
        return Person.eMail;
    }

    public String getCredential(HttpServletRequest request) {
        return this.getValue(request, "email");
    }

    public String getValue(HttpServletRequest request, String key) {
        try {
            OAuthResourceResponse userResponse = this.getUserResponse(request);
            if (userResponse == null) {
                return null;
            }
            String body = userResponse.getBody();
            logger.info("User response body: {}", (Object)body);
            return (String)JSONUtils.parseJSON((String)body).get(key);
        }
        catch (Exception ex) {
            logger.warn("Could not extract {} from JSON response", (Throwable)ex);
            return null;
        }
    }

    public String getAccessToken(HttpServletRequest request) {
        OAuthAccessTokenResponse resp = this.getAccessTokenResponse(request);
        if (resp == null) {
            return null;
        }
        return resp.getAccessToken();
    }

    public Long getExpiresIn(HttpServletRequest request) {
        OAuthAccessTokenResponse resp = this.getAccessTokenResponse(request);
        if (resp == null) {
            return null;
        }
        return resp.getExpiresIn();
    }

    private OAuthAccessTokenResponse getAccessTokenResponse(HttpServletRequest request) {
        if (this.tokenResponse != null) {
            return this.tokenResponse;
        }
        try {
            String code = StructrOAuthClient.getCode(request);
            if (code == null) {
                logger.error("Could not get code from request, cancelling authorization process");
                return null;
            }
            OAuthClientRequest clientReq = OAuthClientRequest.tokenLocation((String)this.tokenLocation).setGrantType(this.getGrantType()).setClientId(this.clientId).setClientSecret(this.clientSecret).setRedirectURI(this.getAbsoluteUrl(request, this.redirectUri)).setCode(StructrOAuthClient.getCode(request)).buildBodyMessage();
            logger.info("Request body: {}", (Object)clientReq.getBody());
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            this.tokenResponse = oAuthClient.accessToken(clientReq, this.tokenResponseClass);
            logger.info("Access token response: {}", (Object)this.tokenResponse.getBody());
            return this.tokenResponse;
        }
        catch (Throwable t) {
            logger.error("Could not get access token response", t);
            return null;
        }
    }

    public String getUserResourceUri() {
        return "";
    }

    public String getReturnUri() {
        return "/";
    }

    public String getErrorUri() {
        return "/";
    }

    protected OAuthResourceResponse getUserResponse(HttpServletRequest request) {
        if (this.userResponse != null) {
            return this.userResponse;
        }
        try {
            String accessToken = this.getAccessToken(request);
            if (accessToken != null) {
                final String accessTokenParameterKey = this.getAccessTokenParameterKey();
                OAuthClientRequest clientReq = new OAuthBearerClientRequest(this.getUserResourceUri()){

                    public OAuthBearerClientRequest setAccessToken(String accessToken) {
                        this.parameters.put(accessTokenParameterKey, accessToken);
                        return this;
                    }
                }.setAccessToken(accessToken).buildQueryMessage();
                clientReq.setHeader("x-li-format", "json");
                logger.info("User info request: {}", (Object)clientReq.getLocationUri());
                OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
                this.userResponse = (OAuthResourceResponse)oAuthClient.resource(clientReq, "GET", OAuthResourceResponse.class);
                logger.info("User info response: {}", (Object)this.userResponse);
                return this.userResponse;
            }
        }
        catch (Throwable t) {
            logger.error("Could not get user response", t);
        }
        return null;
    }

    protected String getAbsoluteUrl(HttpServletRequest request, String redirectUri) {
        return !redirectUri.startsWith("http") ? "http" + (request.isSecure() ? "s" : "") + "://" + request.getServerName() + ":" + request.getServerPort() + redirectUri : redirectUri;
    }

    public ResponseFormat getResponseFormat() {
        return ResponseFormat.json;
    }

    protected static enum ResponseFormat {
        json,
        urlEncoded;

    }
}

