/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.converter;

import java.io.IOException;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.graph.CreationContainer;
import org.structr.web.common.FileHelper;
import org.structr.web.common.ImageHelper;
import org.structr.web.entity.FileBase;

public class FileDataConverter
extends PropertyConverter {
    private static final Logger logger = LoggerFactory.getLogger((String)FileDataConverter.class.getName());

    public FileDataConverter(SecurityContext securityContext, GraphObject entity) {
        super(securityContext, entity);
    }

    public Object convert(Object source) throws FrameworkException {
        String sourceString;
        if (source == null) {
            return false;
        }
        FileBase currentFile = this.getCurrentObject();
        if (source instanceof byte[]) {
            try {
                byte[] data = (byte[])source;
                MagicMatch match = Magic.getMagicMatch((byte[])data);
                String mimeType = match.getMimeType();
                try {
                    FileHelper.setFileData(currentFile, data, mimeType);
                }
                catch (IOException ioex) {
                    logger.warn("Unable to store file", (Throwable)ioex);
                }
            }
            catch (MagicException | MagicMatchNotFoundException | MagicParseException mex) {
                logger.warn("Unable to parse file data", mex);
            }
        } else if (source instanceof String && StringUtils.isNotBlank((CharSequence)(sourceString = (String)source))) {
            FileHelper.Base64URIData uriData = new FileHelper.Base64URIData(sourceString);
            try {
                FileHelper.setFileData(currentFile, uriData.getBinaryData(), uriData.getContentType());
            }
            catch (IOException ioex) {
                logger.warn("Unable to store file", (Throwable)ioex);
            }
        }
        return null;
    }

    public Object revert(Object source) {
        if (this.currentObject instanceof FileBase) {
            FileBase currentFile = (FileBase)this.currentObject;
            return ImageHelper.getBase64String(currentFile);
        }
        return source;
    }

    private FileBase getCurrentObject() {
        if (this.currentObject instanceof CreationContainer) {
            return (FileBase)((CreationContainer)this.currentObject).getWrappedObject();
        }
        return (FileBase)this.currentObject;
    }
}

