/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.converter;

import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.KeyAndClass;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyMap;
import org.structr.web.common.ImageHelper;
import org.structr.web.entity.Image;

public class ImageConverter
extends PropertyConverter {
    private static final Logger logger = LoggerFactory.getLogger((String)ImageConverter.class.getName());
    private KeyAndClass<Image> keyAndClass = null;

    public ImageConverter(SecurityContext securityContext, GraphObject entity, KeyAndClass<Image> kc) {
        super(securityContext, entity);
        this.keyAndClass = kc;
    }

    public Object convert(Object source) {
        if (source == null) {
            return false;
        }
        try {
            Image img = null;
            try {
                String sourceString;
                if (source instanceof byte[]) {
                    byte[] data = (byte[])source;
                    MagicMatch match = Magic.getMagicMatch((byte[])data);
                    String mimeType = match.getMimeType();
                    if (this.keyAndClass != null) {
                        img = (Image)ImageHelper.createFile(this.securityContext, data, mimeType, this.keyAndClass.getCls());
                    } else {
                        ImageHelper.setImageData((Image)this.currentObject, data, mimeType);
                    }
                } else if (source instanceof String && StringUtils.isNotBlank((CharSequence)(sourceString = (String)source))) {
                    if (this.keyAndClass != null) {
                        if (sourceString.length() == 32) {
                            img = (Image)ImageHelper.transformFile(this.securityContext, sourceString, this.keyAndClass != null ? this.keyAndClass.getCls() : null);
                        }
                        if (img == null) {
                            img = (Image)ImageHelper.createFileBase64(this.securityContext, sourceString, this.keyAndClass != null ? this.keyAndClass.getCls() : null);
                        }
                    } else {
                        ImageHelper.decodeAndSetFileData((Image)this.currentObject, sourceString);
                        ImageHelper.updateMetadata((Image)this.currentObject);
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("Cannot create image node from given data", t);
            }
            if (img != null) {
                img.updateInIndex();
                this.currentObject.setProperties(this.securityContext, new PropertyMap(this.keyAndClass.getPropertyKey(), img));
            }
        }
        catch (Throwable t) {
            logger.warn("Cannot create image node from given data", t);
        }
        return null;
    }

    public Object revert(Object source) {
        if (this.currentObject instanceof Image) {
            return ImageHelper.getBase64String((Image)this.currentObject);
        }
        return source;
    }
}

