/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.datasource;

import java.util.Map;
import org.slf4j.LoggerFactory;
import org.structr.api.util.Iterables;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractNode;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.web.common.GraphDataSource;
import org.structr.web.common.RenderContext;
import org.structr.web.entity.dom.DOMNode;

public class FunctionDataSource
implements GraphDataSource<Iterable<GraphObject>> {
    @Override
    public Iterable<GraphObject> getData(RenderContext renderContext, AbstractNode referenceNode) throws FrameworkException {
        String functionQuery = (String)referenceNode.getProperty(DOMNode.functionQuery);
        if (functionQuery == null || functionQuery.isEmpty()) {
            return null;
        }
        try {
            Object result = Scripting.evaluate((ActionContext)renderContext, (GraphObject)referenceNode, (String)("${" + functionQuery + "}"), (String)"function query");
            if (result instanceof Iterable) {
                return FunctionDataSource.map((Iterable)result);
            }
        }
        catch (UnlicensedException ex) {
            ex.log(LoggerFactory.getLogger(FunctionDataSource.class));
        }
        return null;
    }

    public static Iterable<GraphObject> map(Iterable<Object> src) {
        return Iterables.map(t -> {
            if (t instanceof GraphObject) {
                return (GraphObject)t;
            }
            if (t instanceof Map) {
                return Function.toGraphObjectMap((Map)((Map)t));
            }
            throw new ClassCastException(t.getClass() + " cannot be cast to " + GraphObject.class.getName());
        }, src);
    }
}

