/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.diff;

import java.util.List;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyKey;
import org.structr.web.diff.InvertibleModificationOperation;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.relationship.DOMChildren;

public class CreateOperation
extends InvertibleModificationOperation {
    private List<String> siblingHashes = null;
    private String parentHash = null;
    private DOMNode newNode = null;
    private int depth = 0;

    public CreateOperation(Map<String, DOMNode> hashMappedExistingNodes, String parentHash, List<String> siblingHashes, DOMNode newNode, int depth) {
        super(hashMappedExistingNodes);
        this.siblingHashes = siblingHashes;
        this.parentHash = parentHash;
        this.newNode = newNode;
        this.depth = depth;
    }

    public String toString() {
        if (this.newNode instanceof Content) {
            return "Create Content(" + this.newNode.getIdHashOrProperty() + ")";
        }
        return "Create " + (String)this.newNode.getProperty((PropertyKey)DOMElement.tag) + "(" + this.newNode.getIdHashOrProperty() + ")";
    }

    @Override
    public void apply(App app, Page sourcePage, Page newPage) throws FrameworkException {
        InvertibleModificationOperation.InsertPosition insertPosition = this.findInsertPosition(sourcePage, this.parentHash, this.siblingHashes, this.newNode);
        if (insertPosition != null) {
            DOMNode parent = insertPosition.getParent();
            DOMNode sibling = insertPosition.getSibling();
            if (parent != null && !parent.isSynced()) {
                if (sourcePage != null) {
                    sourcePage.adoptNode(this.newNode);
                }
                parent.insertBefore(this.newNode, sibling);
                this.hashMappedExistingNodes.put(this.newNode.getIdHashOrProperty(), this.newNode);
                for (DOMChildren childRel : this.newNode.getChildRelationships()) {
                    app.delete((RelationshipInterface)childRel);
                }
            }
        }
    }

    @Override
    public InvertibleModificationOperation revert() {
        return null;
    }

    @Override
    public Integer getPosition() {
        return 200 + this.depth;
    }
}

