/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.schema.SchemaService;
import org.structr.web.common.FileHelper;
import org.structr.web.common.ImageHelper;
import org.structr.web.entity.relation.Thumbnails;
import org.structr.web.property.ImageDataProperty;
import org.structr.web.property.ThumbnailProperty;

public class Image
extends File {
    private static final Logger logger;
    public static final Property<Integer> height;
    public static final Property<Integer> width;
    public static final Property<Integer> orientation;
    public static final Property<Image> tnSmall;
    public static final Property<Image> tnMid;
    public static final Property<Boolean> isThumbnail;
    public static final ImageDataProperty imageData;
    public static final Property<Boolean> isImage;
    public static final Property<Boolean> isCreatingThumb;
    public static final View uiView;
    public static final View publicView;

    public Object setProperty(PropertyKey key, Object value) throws FrameworkException {
        if (visibleToPublicUsers.equals((Object)key) || visibleToAuthenticatedUsers.equals((Object)key) || visibilityStartDate.equals((Object)key) || visibilityEndDate.equals((Object)key) || owner.equals((Object)key)) {
            for (Image tn : this.getThumbnails()) {
                tn.setProperty(key, value);
            }
        }
        return super.setProperty(key, value);
    }

    public void setProperties(SecurityContext securityContext, PropertyMap properties) throws FrameworkException {
        if (!this.isThumbnail()) {
            PropertyMap propertiesCopiedToAllThumbnails = new PropertyMap();
            for (PropertyKey key : properties.keySet()) {
                if (!visibleToPublicUsers.equals((Object)key) && !visibleToAuthenticatedUsers.equals((Object)key) && !visibilityStartDate.equals((Object)key) && !visibilityEndDate.equals((Object)key) && !owner.equals((Object)key)) continue;
                propertiesCopiedToAllThumbnails.put(key, properties.get(key));
            }
            if (!propertiesCopiedToAllThumbnails.isEmpty()) {
                List<Image> thumbnails = this.getThumbnails();
                for (Image tn : thumbnails) {
                    tn.setProperties(tn.getSecurityContext(), propertiesCopiedToAllThumbnails);
                }
            }
        }
        super.setProperties(securityContext, properties);
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            if (!this.isThumbnail() && modificationQueue.isPropertyModified((GraphObject)this, (PropertyKey)name)) {
                String newImageName = this.getName();
                for (Image tn : this.getThumbnails()) {
                    String currentThumbnailName;
                    String expectedThumbnailName = ImageHelper.getThumbnailName(newImageName, tn.getWidth(), tn.getHeight());
                    if (expectedThumbnailName.equals(currentThumbnailName = tn.getName())) continue;
                    logger.debug("Auto-renaming Thumbnail({}) from '{}' to '{}'", new Object[]{tn.getUuid(), currentThumbnailName, expectedThumbnailName});
                    tn.setProperty((PropertyKey)AbstractNode.name, expectedThumbnailName);
                }
            }
            return true;
        }
        return false;
    }

    public Integer getWidth() {
        return (Integer)this.getProperty((PropertyKey)width);
    }

    public Integer getHeight() {
        return (Integer)this.getProperty((PropertyKey)height);
    }

    public List<Image> getThumbnails() {
        LinkedList<Image> thumbnails = new LinkedList<Image>();
        for (AbstractRelationship abstractRelationship : this.getThumbnailRelationships()) {
            thumbnails.add((Image)abstractRelationship.getTargetNode());
        }
        return thumbnails;
    }

    public Iterable<Thumbnails> getThumbnailRelationships() {
        return this.getOutgoingRelationships(Thumbnails.class);
    }

    public Image getScaledImage(String maxWidthString, String maxHeightString) {
        return this.getScaledImage(Integer.parseInt(maxWidthString), Integer.parseInt(maxHeightString), false);
    }

    public Image getScaledImage(String maxWidthString, String maxHeightString, boolean cropToFit) {
        return this.getScaledImage(Integer.parseInt(maxWidthString), Integer.parseInt(maxHeightString), cropToFit);
    }

    public Image getScaledImage(int maxWidth, int maxHeight) {
        return this.getScaledImage(maxWidth, maxHeight, false);
    }

    public Image getScaledImage(int maxWidth, int maxHeight, boolean cropToFit) {
        Iterable<Thumbnails> thumbnailRelationships = this.getThumbnailRelationships();
        LinkedList<Image> oldThumbnails = new LinkedList<Image>();
        Image thumbnail = null;
        Image originalImage = this;
        Integer origWidth = originalImage.getWidth();
        Integer origHeight = originalImage.getHeight();
        Long currentChecksum = (Long)originalImage.getProperty((PropertyKey)checksum);
        Long newChecksum = currentChecksum == null || currentChecksum == 0L ? FileHelper.getChecksum(originalImage) : currentChecksum;
        String _contentType = (String)this.getProperty((PropertyKey)contentType);
        if (_contentType != null && (_contentType.startsWith("image/svg") || _contentType.startsWith("image/") && _contentType.endsWith("icon"))) {
            return this;
        }
        if (origWidth != null && origHeight != null && thumbnailRelationships != null) {
            for (Thumbnails r : thumbnailRelationships) {
                Integer w = (Integer)r.getProperty((PropertyKey)width);
                Integer h = (Integer)r.getProperty((PropertyKey)height);
                if (w == null || h == null || !(w == maxWidth && h <= maxHeight || w <= maxWidth && h == maxHeight) && (origWidth > w || origHeight > h)) continue;
                thumbnail = (Image)r.getTargetNode();
                Long storedChecksum = (Long)r.getProperty((PropertyKey)checksum);
                if (storedChecksum != null && storedChecksum.equals(newChecksum)) {
                    return thumbnail;
                }
                oldThumbnails.add(thumbnail);
            }
        }
        if (((Boolean)originalImage.getProperty((PropertyKey)isCreatingThumb)).equals(Boolean.TRUE)) {
            logger.debug("Another thumbnail is being created - waiting....");
        } else {
            try {
                logger.debug("Creating thumbnail for {} (w={} h={} crop={})", new Object[]{this.getName(), maxWidth, maxHeight, cropToFit});
                originalImage.unlockSystemPropertiesOnce();
                originalImage.setProperty((PropertyKey)isCreatingThumb, Boolean.TRUE);
                App app = StructrApp.getInstance((SecurityContext)this.securityContext);
                originalImage.unlockSystemPropertiesOnce();
                originalImage.setProperty((PropertyKey)File.checksum, newChecksum);
                ImageHelper.Thumbnail thumbnailData = ImageHelper.createThumbnail(originalImage, maxWidth, maxHeight, cropToFit);
                if (thumbnailData != null) {
                    Integer tnWidth = thumbnailData.getWidth();
                    Integer tnHeight = thumbnailData.getHeight();
                    byte[] data = null;
                    try {
                        data = thumbnailData.getBytes();
                        String thumbnailName = ImageHelper.getThumbnailName(originalImage.getName(), tnWidth, tnHeight);
                        thumbnail = ImageHelper.createImageNode(this.securityContext, data, "image/" + (Object)((Object)ImageHelper.Thumbnail.defaultFormat), Image.class, thumbnailName, true);
                    }
                    catch (IOException ex) {
                        logger.warn("Could not create thumbnail image for " + this.getUuid(), (Throwable)ex);
                    }
                    if (thumbnail != null && data != null) {
                        PropertyMap relProperties = new PropertyMap();
                        relProperties.put(width, (Object)tnWidth);
                        relProperties.put(height, (Object)tnHeight);
                        relProperties.put((PropertyKey)checksum, (Object)newChecksum);
                        app.create((NodeInterface)originalImage, (NodeInterface)thumbnail, Thumbnails.class, relProperties);
                        PropertyMap properties = new PropertyMap();
                        properties.put(width, (Object)tnWidth);
                        properties.put(height, (Object)tnHeight);
                        properties.put((PropertyKey)AbstractNode.hidden, originalImage.getProperty((PropertyKey)AbstractNode.hidden));
                        properties.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, originalImage.getProperty((PropertyKey)AbstractNode.visibleToAuthenticatedUsers));
                        properties.put((PropertyKey)AbstractNode.visibleToPublicUsers, originalImage.getProperty((PropertyKey)AbstractNode.visibleToPublicUsers));
                        properties.put((PropertyKey)File.size, (Object)data.length);
                        properties.put((PropertyKey)AbstractNode.owner, originalImage.getProperty((PropertyKey)AbstractNode.owner));
                        properties.put((PropertyKey)File.parent, originalImage.getProperty((PropertyKey)File.parent));
                        thumbnail.unlockSystemPropertiesOnce();
                        thumbnail.setProperties(this.securityContext, properties);
                        for (Image tn : oldThumbnails) {
                            app.delete((NodeInterface)tn);
                        }
                    }
                } else {
                    logger.debug("Could not create thumbnail for image {} ({})", (Object)this.getName(), (Object)this.getUuid());
                }
                originalImage.unlockSystemPropertiesOnce();
                originalImage.removeProperty((PropertyKey)isCreatingThumb);
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to create thumbnail for " + this.getUuid(), (Throwable)fex);
            }
        }
        return thumbnail;
    }

    public boolean isThumbnail() {
        return (Boolean)this.getProperty((PropertyKey)isThumbnail) != false || this.getIncomingRelationship(Thumbnails.class) != null;
    }

    public String getOriginalImageName() {
        Integer tnWidth = this.getWidth();
        Integer tnHeight = this.getHeight();
        return StringUtils.stripEnd((String)this.getName(), (String)("_thumb_" + tnWidth + "x" + tnHeight));
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"Image", (String)Image.class.getName());
        logger = LoggerFactory.getLogger((String)Image.class.getName());
        height = new IntProperty("height").cmis().indexed();
        width = new IntProperty("width").cmis().indexed();
        orientation = new IntProperty("orientation").cmis().indexed();
        tnSmall = new ThumbnailProperty("tnSmall").format("100, 100, false");
        tnMid = new ThumbnailProperty("tnMid").format("300, 300, false");
        isThumbnail = new BooleanProperty("isThumbnail").indexed().unvalidated().systemInternal();
        imageData = new ImageDataProperty("imageData");
        isImage = new ConstantBooleanProperty("isImage", true);
        isCreatingThumb = new BooleanProperty("isCreatingThumb").systemInternal();
        uiView = new View(Image.class, "ui", new Property[]{type, name, contentType, size, relativeFilePath, width, height, orientation, tnSmall, tnMid, isThumbnail, owner, parent, path, isImage});
        publicView = new View(Image.class, "public", new Property[]{type, name, width, height, orientation, tnSmall, tnMid, isThumbnail, owner, parent, path, isImage});
    }
}

