/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.structr.common.SecurityContext;
import org.structr.common.ThreadLocalMatcher;
import org.structr.common.View;
import org.structr.common.error.EmptyPropertyToken;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.notion.Notion;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.EndNodes;
import org.structr.core.property.Property;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaService;
import org.structr.web.entity.Image;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.relation.ImageWidget;
import org.structr.web.importer.Importer;
import org.structr.web.maintenance.deploy.DeploymentCommentHandler;
import org.structr.web.property.UiNotion;

public class Widget
extends AbstractNode {
    private static final ThreadLocalMatcher threadLocalTemplateMatcher = new ThreadLocalMatcher("\\[[^\\]]+\\]");
    public static final Property<String> source = new StringProperty("source").cmis();
    public static final Property<String> description = new StringProperty("description").cmis();
    public static final Property<String> configuration = new StringProperty("configuration").cmis();
    public static final Property<String> treePath = new StringProperty("treePath").cmis().indexed();
    public static final Property<List<Image>> pictures = new EndNodes("pictures", ImageWidget.class, (Notion)new UiNotion());
    public static final Property<Boolean> isWidget = new ConstantBooleanProperty("isWidget", true);
    public static final View uiView = new View(Widget.class, "ui", new Property[]{type, name, source, description, configuration, pictures, treePath, isWidget});
    public static final View publicView = new View(Widget.class, "public", new Property[]{type, name, source, description, configuration, pictures, treePath, isWidget});

    public static void expandWidget(SecurityContext securityContext, Page page, DOMNode parent, String baseUrl, Map<String, Object> parameters, boolean processDeploymentInfo) throws FrameworkException {
        Importer importer;
        String _source = (String)parameters.get("source");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        if (_source == null) {
            errorBuffer.add((ErrorToken)new EmptyPropertyToken(Widget.class.getSimpleName(), source));
        } else {
            Matcher matcher = (Matcher)threadLocalTemplateMatcher.get();
            matcher.reset(_source);
            while (matcher.find()) {
                String group = matcher.group();
                String source = group.substring(1, group.length() - 1);
                ReplacementInfo info = new ReplacementInfo(source);
                String key = info.getKey();
                Object value = parameters.get(key);
                if (value == null) continue;
                _source = _source.replace(group, value.toString());
                matcher.reset(_source);
            }
        }
        if (!errorBuffer.hasError()) {
            importer = new Importer(securityContext, _source, baseUrl, null, false, false);
            if (processDeploymentInfo) {
                importer.setIsDeployment(true);
                importer.setCommentHandler(new DeploymentCommentHandler());
            }
        } else {
            throw new FrameworkException(422, "Unable to import the given source code", errorBuffer);
        }
        importer.parse(true);
        importer.createChildNodes(parent, page, true);
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"Widget", (String)Widget.class.getName());
    }

    public static class ReplacementInfo {
        private ArrayList<String> options = new ArrayList();
        private String key = null;
        private boolean hasOptions = false;

        public ReplacementInfo(String value) {
            this.key = value;
            if (value.contains(":")) {
                String[] parts = value.split("[:]+");
                this.key = parts[0];
                if (parts[1].contains(",")) {
                    String[] opts = parts[1].split("[,]+");
                    int count = opts.length;
                    for (int i = 0; i < count; ++i) {
                        String trimmedPart = opts[i].trim();
                        if (trimmedPart.isEmpty()) continue;
                        this.options.add(trimmedPart);
                    }
                    this.hasOptions = true;
                }
            }
        }

        public String getKey() {
            return this.key;
        }

        public ArrayList<String> getOptions() {
            return this.options;
        }

        public boolean hasOptions() {
            return this.hasOptions;
        }
    }
}

