/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.html;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.common.HtmlProperty;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMElement;
import org.w3c.dom.Node;

public class Style
extends DOMElement {
    private static final Logger logger = LoggerFactory.getLogger((String)Style.class.getName());
    public static final Property<String> _media = new HtmlProperty("media");
    public static final Property<String> _type = new HtmlProperty("type");
    public static final Property<String> _scoped = new HtmlProperty("scoped");
    public static final View htmlView = new View(Style.class, "_html_", new Property[]{_media, _type, _scoped});

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.isValid(errorBuffer)) {
            this.setProperty((PropertyKey)_type, "text/css");
            return true;
        }
        return false;
    }

    @Override
    public Property[] getHtmlAttributes() {
        return (Property[])ArrayUtils.addAll((Object[])super.getHtmlAttributes(), (Object[])htmlView.properties());
    }

    @Override
    protected void handleNewChild(Node newChild) {
        if (newChild instanceof Content) {
            Content content = (Content)newChild;
            try {
                String childContentType = (String)content.getProperty((PropertyKey)Content.contentType);
                String thisContentType = (String)this.getProperty((PropertyKey)_type);
                if (childContentType == null && thisContentType != null) {
                    content.setProperties(this.securityContext, new PropertyMap(Content.contentType, (Object)thisContentType));
                }
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to set property on new child: {}", (Object)fex.getMessage());
            }
        }
    }
}

