/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.structr.core.GraphObjectMap;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class FromJsonFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_FROM_JSON = "Usage: ${from_json(src)}. Example: ${from_json('{name:test}')}";
    public static final String ERROR_MESSAGE_FROM_JSON_JS = "Usage: ${{Structr.from_json(src)}}. Example: ${{Structr.from_json('{name:test}')}}";

    public String getName() {
        return "from_json()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (sources != null && sources.length > 0) {
            if (sources[0] == null) {
                return "";
            }
            try {
                String source = sources[0].toString();
                Gson gson = new GsonBuilder().create();
                LinkedList objects = new LinkedList();
                if (StringUtils.startsWith((CharSequence)source, (CharSequence)"[")) {
                    List list = (List)gson.fromJson(source, new TypeToken<List<Map<String, Object>>>(){}.getType());
                    LinkedList<GraphObjectMap> elements = new LinkedList<GraphObjectMap>();
                    if (list != null) {
                        objects.addAll(list);
                    }
                    for (Map src : objects) {
                        GraphObjectMap destination = new GraphObjectMap();
                        elements.add(destination);
                        FromJsonFunction.recursivelyConvertMapToGraphObjectMap((GraphObjectMap)destination, (Map)src, (int)0);
                    }
                    return elements;
                }
                if (StringUtils.startsWith((CharSequence)source, (CharSequence)"{")) {
                    Map value = (Map)gson.fromJson(source, new TypeToken<Map<String, Object>>(){}.getType());
                    GraphObjectMap destination = new GraphObjectMap();
                    if (value != null) {
                        FromJsonFunction.recursivelyConvertMapToGraphObjectMap((GraphObjectMap)destination, (Map)value, (int)0);
                    }
                    return destination;
                }
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
            }
            return "";
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_FROM_JSON_JS : ERROR_MESSAGE_FROM_JSON;
    }

    public String shortDescription() {
        return "Parses the given JSON string and returns an object";
    }
}

