/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.util.ArrayList;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.structr.rest.common.HttpHelper;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class HttpGetFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_GET = "Usage: ${GET(URL[, contentType[, selector]])}. Example: ${GET('http://structr.org', 'text/html')}";
    public static final String ERROR_MESSAGE_GET_JS = "Usage: ${{Structr.GET(URL[, contentType[, selector]])}}. Example: ${{Structr.HEAD('http://structr.org', 'text/html')}}";

    public String getName() {
        return "GET()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (sources != null && sources.length >= 1 && sources.length <= 4 && sources[0] != null) {
            try {
                String address = sources[0].toString();
                String contentType = null;
                String username = null;
                String password = null;
                switch (sources.length) {
                    case 4: {
                        password = sources[3].toString();
                    }
                    case 3: {
                        username = sources[2].toString();
                    }
                    case 2: {
                        contentType = sources[1].toString();
                    }
                }
                if ("text/html".equals(contentType)) {
                    Document doc = Jsoup.parse((String)HttpHelper.get(address, ctx.getHeaders()));
                    if (sources.length > 2) {
                        Elements elements = doc.select(sources[2].toString());
                        if (elements.size() > 1) {
                            ArrayList<String> parts = new ArrayList<String>();
                            for (Element el : elements) {
                                parts.add(el.html());
                            }
                            return parts;
                        }
                        return elements.html();
                    }
                    return doc.html();
                }
                return this.getFromUrl(ctx, address, username, password);
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                return "";
            }
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_GET_JS : ERROR_MESSAGE_GET;
    }

    public String shortDescription() {
        return "Sends an HTTP GET request to the given URL and returns the response headers and body";
    }
}

