/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.StaticValue;
import org.structr.core.Value;
import org.structr.rest.serialization.StreamingJsonWriter;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class ToJsonFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_TO_JSON = "Usage: ${to_json(obj [, view[, depth = 3]])}. Example: ${to_json(this, 'public', 4)}";
    public static final String ERROR_MESSAGE_TO_JSON_JS = "Usage: ${{Structr.to_json(obj [, view[, depth = 3]])}}. Example: ${{Structr.to_json(Structr.get('this'), 'public', 4)}}";

    public String getName() {
        return "to_json()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (sources != null && sources.length >= 1 && sources.length <= 3) {
            try {
                SecurityContext securityContext = ctx.getSecurityContext();
                StaticValue view = new StaticValue((Object)"public");
                if (sources.length > 1) {
                    view.set(securityContext, (Object)sources[1].toString());
                }
                int outputDepth = 3;
                if (sources.length > 2 && sources[2] instanceof Number) {
                    outputDepth = ((Number)sources[2]).intValue();
                }
                StreamingJsonWriter jsonStreamer = new StreamingJsonWriter((Value<String>)view, true, outputDepth);
                StringWriter writer = new StringWriter();
                if (sources[0] instanceof GraphObject) {
                    jsonStreamer.streamSingle(securityContext, writer, (GraphObject)sources[0]);
                } else if (sources[0] instanceof List) {
                    List list = (List)sources[0];
                    jsonStreamer.stream(securityContext, writer, new Result(list, Integer.valueOf(list.size()), true, false), null);
                } else if (sources[0] instanceof Map) {
                    GraphObjectMap map = new GraphObjectMap();
                    ToJsonFunction.recursivelyConvertMapToGraphObjectMap((GraphObjectMap)map, (Map)((Map)sources[0]), (int)outputDepth);
                    jsonStreamer.stream(securityContext, writer, new Result((GraphObject)map, false), null);
                }
                return writer.getBuffer().toString();
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                return "";
            }
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_TO_JSON_JS : ERROR_MESSAGE_TO_JSON;
    }

    public String shortDescription() {
        return "Serializes the given entity to JSON";
    }
}

