/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.maintenance.deploy;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.LinkSource;
import org.structr.web.entity.Linkable;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.importer.CommentHandler;

public class DeploymentCommentHandler
implements CommentHandler {
    private static final Set<Character> separators = new LinkedHashSet<Character>(Arrays.asList(Character.valueOf(','), Character.valueOf(';'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r')));
    private static final Logger logger = LoggerFactory.getLogger((String)DeploymentCommentHandler.class.getName());
    private static final Map<String, Handler> handlers = new LinkedHashMap<String, Handler>();
    private char[] source = null;
    private int currentPosition = 0;
    private int sourceLength = 0;

    @Override
    public boolean containsInstructions(String comment) {
        try {
            return this.parseInstructions(null, null, comment, false);
        }
        catch (FrameworkException fex) {
            logger.warn("Unexpected exception, no changes should be made in this method: {}", (Object)fex.getMessage());
            return false;
        }
    }

    @Override
    public boolean handleComment(Page page, DOMNode node, String comment, boolean apply) throws FrameworkException {
        return this.parseInstructions(page, node, comment.trim(), apply);
    }

    private boolean parseInstructions(Page page, DOMNode node, String src, boolean apply) throws FrameworkException {
        this.source = src.toCharArray();
        this.sourceLength = src.length();
        this.currentPosition = 0;
        boolean hit = false;
        while (this.currentPosition < this.sourceLength) {
            if (!this.findSequence("@structr:")) continue;
            hit = true;
            String token = this.getNextToken();
            Handler handler = handlers.get(token);
            String parameters = null;
            if (handler != null) {
                if (this.hasMore()) {
                    char c = this.source[this.currentPosition++];
                    switch (c) {
                        case '(': {
                            parameters = this.getUntilClosingParenthesis();
                            break;
                        }
                    }
                }
                if (!apply) continue;
                handler.apply(page, node, parameters);
                continue;
            }
            logger.warn("Unknown token {}, expected one of {}.", new Object[]{token, handlers.keySet()});
            break;
        }
        return hit;
    }

    private boolean findSequence(String sequence) {
        StringBuilder buf = new StringBuilder();
        char[] seq = sequence.toCharArray();
        int len = seq.length;
        boolean sequenceStarted = false;
        for (int i = 0; i < len; ++i) {
            if (!this.hasMore()) continue;
            char c = Character.toLowerCase(this.source[this.currentPosition++]);
            char s = Character.toLowerCase(seq[i]);
            if (!sequenceStarted && Character.isWhitespace(c) || separators.contains(Character.valueOf(c))) {
                i = -1;
                continue;
            }
            if (c != s) {
                return false;
            }
            sequenceStarted = true;
            buf.append(c);
        }
        return buf.toString().equals(sequence);
    }

    private String getNextToken() {
        char c;
        StringBuilder buf = new StringBuilder();
        while (this.hasMore() && !Character.isWhitespace(c = this.source[this.currentPosition]) && !separators.contains(Character.valueOf(c))) {
            buf.append(c);
            ++this.currentPosition;
        }
        return buf.toString();
    }

    private String getUntilClosingParenthesis() {
        StringBuilder buf = new StringBuilder();
        int count = 1;
        while (this.hasMore()) {
            char c;
            if ((c = this.source[this.currentPosition++]) == '(') {
                ++count;
            }
            if (c == ')' && --count == 0) break;
            buf.append(c);
        }
        return buf.toString();
    }

    private boolean hasMore() {
        return this.currentPosition < this.sourceLength;
    }

    static {
        handlers.put("public-only", (page, node, parameters) -> {
            PropertyMap changedProperties = new PropertyMap();
            changedProperties.put((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)true);
            changedProperties.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)false);
            node.setProperties(node.getSecurityContext(), changedProperties);
        });
        handlers.put("public", (page, node, parameters) -> {
            PropertyMap changedProperties = new PropertyMap();
            changedProperties.put((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)true);
            changedProperties.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)true);
            node.setProperties(node.getSecurityContext(), changedProperties);
        });
        handlers.put("protected", (page, node, parameters) -> {
            PropertyMap changedProperties = new PropertyMap();
            changedProperties.put((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)false);
            changedProperties.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)true);
            node.setProperties(node.getSecurityContext(), changedProperties);
        });
        handlers.put("private", (page, node, parameters) -> {
            PropertyMap changedProperties = new PropertyMap();
            changedProperties.put((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)false);
            changedProperties.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)false);
            node.setProperties(node.getSecurityContext(), changedProperties);
        });
        handlers.put("link", (page, node, parameters) -> {
            Linkable file;
            if (node instanceof LinkSource && (file = (Linkable)StructrApp.getInstance().nodeQuery(Linkable.class).and(AbstractFile.path, (Object)parameters).getFirst()) != null) {
                LinkSource linkSource = (LinkSource)node;
                linkSource.setProperties(linkSource.getSecurityContext(), new PropertyMap(LinkSource.linkable, (Object)file));
            }
        });
        handlers.put("content", (page, node, parameters) -> node.setProperties(node.getSecurityContext(), new PropertyMap(Content.contentType, (Object)parameters)));
        handlers.put("show", (page, node, parameters) -> node.setProperties(node.getSecurityContext(), new PropertyMap(DOMNode.showConditions, (Object)parameters)));
        handlers.put("hide", (page, node, parameters) -> node.setProperties(node.getSecurityContext(), new PropertyMap(DOMNode.hideConditions, (Object)parameters)));
        handlers.put("owner", (page, node, parameters) -> {
            Principal owner = (Principal)StructrApp.getInstance().nodeQuery(Principal.class).andName(parameters).getFirst();
            if (owner != null) {
                node.setProperty((PropertyKey)AbstractNode.owner, owner);
            } else {
                logger.warn("Unknown owner {}, ignoring.", (Object)parameters);
            }
        });
        handlers.put("grant", (page, node, parameters) -> {
            String[] parts = parameters.split("[,]+");
            if (parts.length == 2) {
                Principal grantee = (Principal)StructrApp.getInstance().nodeQuery(Principal.class).andName(parts[0]).getFirst();
                if (grantee != null) {
                    block6: for (char c : parts[1].toCharArray()) {
                        switch (c) {
                            case 'a': {
                                node.grant(Permission.accessControl, grantee);
                                continue block6;
                            }
                            case 'r': {
                                node.grant(Permission.read, grantee);
                                continue block6;
                            }
                            case 'w': {
                                node.grant(Permission.write, grantee);
                                continue block6;
                            }
                            case 'd': {
                                node.grant(Permission.delete, grantee);
                                continue block6;
                            }
                            default: {
                                logger.warn("Invalid @grant permission {}, must be one of [a, r, w, d].", (Object)Character.valueOf(c));
                            }
                        }
                    }
                } else {
                    logger.warn("Unknown grantee {}, ignoring.", (Object)parts[0]);
                }
            } else {
                logger.warn("Invalid @grant instruction {}, must be like @structr:grant(userName,rw).", (Object)parameters);
            }
        });
    }

    private static interface Handler {
        public void apply(Page var1, DOMNode var2, String var3) throws FrameworkException;
    }
}

