/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.maintenance.deploy;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.web.common.FileHelper;
import org.structr.web.common.ImageHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.Image;
import org.structr.web.entity.relation.Thumbnails;

public class FileImportVisitor
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger((String)FileImportVisitor.class.getName());
    private Map<String, Object> config = null;
    private SecurityContext securityContext = SecurityContext.getSuperUserInstance();
    private Path basePath = null;
    private App app = null;

    public FileImportVisitor(Path basePath, Map<String, Object> config) {
        this.securityContext.setDoTransactionNotifications(false);
        this.basePath = basePath;
        this.config = config;
        this.app = StructrApp.getInstance((SecurityContext)this.securityContext);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (attrs.isDirectory()) {
            this.createFolder(file);
        } else if (attrs.isRegularFile()) {
            String fileName = file.getFileName().toString();
            this.createFile(file, fileName);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        logger.warn("Exception while importing file {}: {}", new Object[]{file.toString(), exc.getMessage()});
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    private void createFolder(Path file) {
        try (Tx tx = this.app.tx(true, false, false);){
            PropertyMap properties;
            Folder folder = this.createFolders(this.basePath.relativize(file));
            if (folder != null && (properties = this.getPropertiesForFileOrFolder(folder.getPath())) != null) {
                folder.setProperties(this.securityContext, properties);
            }
            tx.success();
        }
        catch (Exception ex) {
            logger.error("Error occured while importing folder " + file, (Throwable)ex);
        }
    }

    private void createFile(Path path, String fileName) throws IOException {
        Throwable throwable;
        Tx tx;
        String newFileUuid = null;
        try {
            tx = this.app.tx(true, false, false);
            throwable = null;
            try {
                PropertyMap fileProperties;
                Path parentPath = this.basePath.relativize(path).getParent();
                Folder parent = this.createFolders(parentPath);
                String fullPath = (parentPath != null ? "/" + parentPath.toString() : "") + "/" + fileName;
                FileBase file = (FileBase)this.app.nodeQuery(FileBase.class).and((PropertyKey)FileBase.parent, (Object)parent).and((PropertyKey)FileBase.name, (Object)fileName).getFirst();
                if (file != null) {
                    Long checksumOfExistingFile = file.getChecksum();
                    Long checksumOfNewFile = FileHelper.getChecksum(path.toFile());
                    if (checksumOfExistingFile != null && checksumOfNewFile != null && checksumOfExistingFile.equals(checksumOfNewFile)) {
                        logger.info("Checksum of {} is unmodified, skipping data import.", (Object)fullPath);
                    } else {
                        this.app.delete((NodeInterface)file);
                        file = null;
                    }
                }
                if (file == null) {
                    logger.info("Importing {}...", (Object)fullPath);
                    try (FileInputStream fis = new FileInputStream(path.toFile());){
                        file = FileHelper.createFile(this.securityContext, fis, null, File.class, fileName);
                        String contentType = file.getContentType();
                        PropertyMap changedProperties = new PropertyMap();
                        if (StringUtils.startsWith((CharSequence)contentType, (CharSequence)"image") || ImageHelper.isImageType((String)file.getProperty((PropertyKey)NodeInterface.name))) {
                            changedProperties.put((PropertyKey)NodeInterface.type, (Object)Image.class.getSimpleName());
                        }
                        file.setProperty((PropertyKey)FileBase.parent, (Object)parent);
                        file.unlockSystemPropertiesOnce();
                        file.setProperties(this.securityContext, changedProperties);
                        newFileUuid = file.getUuid();
                    }
                }
                if ((fileProperties = this.getPropertiesForFileOrFolder(file.getPath())) == null) {
                    logger.info(" -> No corresponding entry in files.json, ignoring {}", (Object)fileName);
                    return;
                }
                file.unlockSystemPropertiesOnce();
                file.setProperties(this.securityContext, fileProperties);
                tx.success();
            }
            catch (Throwable parentPath) {
                throwable = parentPath;
                throw parentPath;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error occured while importing file " + fileName, (Throwable)ex);
        }
        try {
            tx = this.app.tx(true, false, false);
            throwable = null;
            try {
                if (newFileUuid != null) {
                    FileBase createdFile = (FileBase)this.app.get(newFileUuid);
                    String type = createdFile.getType();
                    boolean isImage = (Boolean)createdFile.getProperty((PropertyKey)Image.isImage);
                    boolean isThumbnail = (Boolean)createdFile.getProperty((PropertyKey)Image.isThumbnail);
                    logger.debug("File {}: {}, isImage? {}, isThumbnail? {}", new Object[]{createdFile.getName(), type, isImage, isThumbnail});
                    if (isImage) {
                        try {
                            ImageHelper.updateMetadata(createdFile);
                            this.handleThumbnails((Image)createdFile);
                        }
                        catch (Throwable t) {
                            logger.warn("Unable to update metadata: {}", (Object)t.getMessage());
                        }
                    }
                }
                tx.success();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error occured while importing file " + fileName, (Throwable)ex);
        }
    }

    private void handleThumbnails(Image img) {
        if (((Boolean)img.getProperty((PropertyKey)Image.isThumbnail)).booleanValue()) {
            if (img.getIncomingRelationship(Thumbnails.class) == null) {
                ImageHelper.findAndReconnectOriginalImage(img);
            }
        } else if (!img.getOutgoingRelationships(Thumbnails.class).iterator().hasNext()) {
            ImageHelper.findAndReconnectThumbnails(img);
        }
    }

    private PropertyMap getPropertiesForFileOrFolder(String path) throws FrameworkException {
        Object data = this.config.get(path);
        if (data != null && data instanceof Map) {
            return PropertyMap.inputTypeToJavaType((SecurityContext)SecurityContext.getSuperUserInstance(), AbstractFile.class, (Map)((Map)data));
        }
        return null;
    }

    private Folder createFolders(Path folder) throws FrameworkException {
        if (folder != null) {
            App app = StructrApp.getInstance();
            Folder current = null;
            Folder parent = null;
            for (Path part : folder) {
                PropertyMap properties;
                String name = part.toString();
                current = (Folder)app.nodeQuery(Folder.class).andName(name).and((PropertyKey)FileBase.parent, parent).getFirst();
                if (current == null && (properties = this.getPropertiesForFileOrFolder((current = (Folder)app.create(Folder.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.name, (Object)name), new NodeAttribute((PropertyKey)Folder.parent, (Object)parent)})).getPath())) != null) {
                    current.unlockSystemPropertiesOnce();
                    current.setProperties(this.securityContext, properties);
                }
                parent = current;
            }
            return current;
        }
        return null;
    }
}

