/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.RetryException;
import org.structr.api.config.Settings;
import org.structr.common.AccessMode;
import org.structr.common.PathHelper;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.ThreadLocalMatcher;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.exception.AuthenticationException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.Image;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.service.StructrHttpServiceConfig;
import org.structr.schema.SchemaHelper;
import org.structr.web.auth.UiAuthenticator;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public class UploadServlet
extends HttpServlet
implements HttpServiceServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)UploadServlet.class.getName());
    private static final ThreadLocalMatcher threadLocalUUIDMatcher = new ThreadLocalMatcher("[a-fA-F0-9]{32}");
    private static final String REDIRECT_AFTER_UPLOAD_PARAMETER = "redirectOnSuccess";
    private static final String APPEND_UUID_ON_REDIRECT_PARAMETER = "appendUuidOnRedirect";
    private static final String UPLOAD_FOLDER_PATH_PARAMETER = "uploadFolderPath";
    private static final int MEGABYTE = 0x100000;
    private static final int MEMORY_THRESHOLD = 0xA00000;
    private ServletFileUpload uploader = null;
    private File filesDir = null;
    private final StructrHttpServiceConfig config = new StructrHttpServiceConfig();

    @Override
    public StructrHttpServiceConfig getConfig() {
        return this.config;
    }

    public String getModuleName() {
        return "ui";
    }

    public void init() {
        try (Tx tx = StructrApp.getInstance().tx();){
            DiskFileItemFactory fileFactory = new DiskFileItemFactory();
            fileFactory.setSizeThreshold(0xA00000);
            this.filesDir = new File((String)Settings.TmpPath.getValue());
            if (!this.filesDir.exists()) {
                this.filesDir.mkdir();
            }
            fileFactory.setRepository(this.filesDir);
            this.uploader = new ServletFileUpload((FileItemFactory)fileFactory);
            tx.success();
        }
        catch (FrameworkException t) {
            logger.warn("", (Throwable)t);
        }
    }

    public void destroy() {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                response.setStatus(400);
                response.getOutputStream().write("ERROR (400): Request does not contain multipart content.\n".getBytes("UTF-8"));
                return;
            }
        }
        catch (IOException ioex) {
            logger.warn("Unable to send response", (Throwable)ioex);
        }
        SecurityContext securityContext = null;
        String redirectUrl = null;
        boolean appendUuidOnRedirect = false;
        String path = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            try {
                securityContext = this.getConfig().getAuthenticator().initializeAndExamineRequest(request, response);
            }
            catch (AuthenticationException ae) {
                response.setStatus(401);
                response.getOutputStream().write("ERROR (401): Invalid user or password.\n".getBytes("UTF-8"));
                if (tx != null) {
                    if (var8_12 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to examine request", (Throwable)fex);
        }
        catch (IOException ioex) {
            logger.warn("Unable to send response", (Throwable)ioex);
        }
        if (securityContext == null) {
            logger.warn("No SecurityContext, aborting.");
            return;
        }
        try {
            if (securityContext.getUser(false) == null && !((Boolean)Settings.UploadAllowAnonymous.getValue()).booleanValue()) {
                response.setStatus(401);
                response.getOutputStream().write("ERROR (401): Anonymous uploads forbidden.\n".getBytes("UTF-8"));
                return;
            }
            securityContext.setAccessMode(AccessMode.Frontend);
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            if (response.getStatus() == 302) {
                return;
            }
            String pathInfo = request.getPathInfo();
            String type = null;
            if (StringUtils.isNotBlank((String)pathInfo)) {
                type = SchemaHelper.normalizeEntityName((String)StringUtils.stripStart((String)pathInfo.trim(), (String)"/"));
            }
            this.uploader.setFileSizeMax((long)(0x100000 * (Integer)Settings.UploadMaxFileSize.getValue()));
            this.uploader.setSizeMax((long)(0x100000 * (Integer)Settings.UploadMaxRequestSize.getValue()));
            response.setContentType("text/html");
            List fileItemsList = this.uploader.parseRequest(request);
            Iterator fileItemsIterator = fileItemsList.iterator();
            HashMap<String, String> params = new HashMap<String, String>();
            while (fileItemsIterator.hasNext()) {
                FileItem item = (FileItem)fileItemsIterator.next();
                if (item.isFormField()) {
                    String fieldName = item.getFieldName();
                    if (REDIRECT_AFTER_UPLOAD_PARAMETER.equals(fieldName)) {
                        redirectUrl = item.getString();
                        continue;
                    }
                    if (APPEND_UUID_ON_REDIRECT_PARAMETER.equals(fieldName)) {
                        appendUuidOnRedirect = "true".equalsIgnoreCase(item.getString());
                        continue;
                    }
                    if (UPLOAD_FOLDER_PATH_PARAMETER.equals(fieldName)) {
                        path = item.getString();
                        continue;
                    }
                    params.put(item.getFieldName(), item.getString());
                    continue;
                }
                try {
                    boolean isVideo;
                    String contentType = item.getContentType();
                    boolean isImage = contentType != null && contentType.startsWith("image");
                    boolean bl = isVideo = contentType != null && contentType.startsWith("video");
                    if (params.containsKey(NodeInterface.type.jsonName())) {
                        type = (String)params.get(NodeInterface.type.jsonName());
                    }
                    Class cls = null;
                    if (type != null) {
                        cls = SchemaHelper.getEntityClassForRawType((String)type);
                    }
                    if (cls == null) {
                        if (isImage) {
                            cls = Image.class;
                        } else if (isVideo) {
                            cls = SchemaHelper.getEntityClassForRawType((String)"VideoFile");
                            if (cls == null) {
                                logger.warn("Unable to create entity of type VideoFile, class is not defined.");
                            }
                        } else {
                            cls = org.structr.dynamic.File.class;
                        }
                    }
                    if (cls != null) {
                        type = cls.getSimpleName();
                    }
                    String name = item.getName().replaceAll("\\\\", "/");
                    FileBase newFile = null;
                    String uuid = null;
                    boolean retry = true;
                    while (retry) {
                        retry = false;
                        try {
                            Tx tx = StructrApp.getInstance().tx();
                            Throwable throwable = null;
                            try {
                                newFile = FileHelper.createFile(securityContext, IOUtils.toByteArray((InputStream)item.getInputStream()), contentType, cls);
                                PropertyMap changedProperties = new PropertyMap();
                                changedProperties.put((PropertyKey)AbstractNode.name, (Object)PathHelper.getName((String)name));
                                changedProperties.putAll(PropertyMap.inputTypeToJavaType((SecurityContext)securityContext, (Class)cls, params));
                                changedProperties.put((PropertyKey)AbstractNode.type, (Object)type);
                                Folder uploadFolder = null;
                                String defaultUploadFolderConfigValue = (String)Settings.DefaultUploadFolder.getValue();
                                if (path != null) {
                                    uploadFolder = FileHelper.createFolderPath(securityContext, path);
                                } else if (StringUtils.isNotBlank((String)defaultUploadFolderConfigValue)) {
                                    uploadFolder = FileHelper.createFolderPath(SecurityContext.getSuperUserInstance(), defaultUploadFolderConfigValue);
                                }
                                if (uploadFolder != null) {
                                    changedProperties.put((PropertyKey)FileBase.hasParent, (Object)true);
                                    changedProperties.put((PropertyKey)FileBase.parent, (Object)uploadFolder);
                                }
                                newFile.setProperties(securityContext, changedProperties);
                                uuid = newFile.getUuid();
                                tx.success();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (tx == null) continue;
                                if (throwable != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                tx.close();
                            }
                        }
                        catch (RetryException rex) {
                            retry = true;
                        }
                    }
                    if (newFile == null) continue;
                    newFile.notifyUploadCompletion();
                    if (StringUtils.isNotBlank((String)redirectUrl)) {
                        if (appendUuidOnRedirect) {
                            response.sendRedirect(redirectUrl + uuid);
                            continue;
                        }
                        response.sendRedirect(redirectUrl);
                        continue;
                    }
                    response.getWriter().write(uuid);
                }
                catch (IOException ex) {
                    logger.warn("Could not upload file", (Throwable)ex);
                }
            }
        }
        catch (Throwable t) {
            String content;
            if (t instanceof FrameworkException) {
                FrameworkException fex = (FrameworkException)t;
                logger.error(fex.toString());
                content = this.errorPage(fex);
            } else {
                logger.error("Exception while processing upload request", t);
                content = this.errorPage(t);
            }
            try {
                ServletOutputStream out = response.getOutputStream();
                IOUtils.write((String)content, (OutputStream)out);
            }
            catch (IOException ex) {
                logger.error("Could not write to response", (Throwable)ex);
            }
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try (Tx tx = StructrApp.getInstance().tx(true, false, false);){
            String uuid = PathHelper.getName((String)request.getPathInfo());
            if (uuid == null) {
                response.setStatus(400);
                response.getOutputStream().write("URL path doesn't end with UUID.\n".getBytes("UTF-8"));
                return;
            }
            Matcher matcher = (Matcher)threadLocalUUIDMatcher.get();
            matcher.reset(uuid);
            if (!matcher.matches()) {
                response.setStatus(400);
                response.getOutputStream().write("ERROR (400): URL path doesn't end with UUID.\n".getBytes("UTF-8"));
                return;
            }
            SecurityContext securityContext = this.getConfig().getAuthenticator().initializeAndExamineRequest(request, response);
            securityContext.setAccessMode(AccessMode.Frontend);
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            if (response.getStatus() == 302) {
                return;
            }
            this.uploader.setFileSizeMax((long)(0x100000 * (Integer)Settings.UploadMaxFileSize.getValue()));
            this.uploader.setSizeMax((long)(0x100000 * (Integer)Settings.UploadMaxRequestSize.getValue()));
            List fileItemsList = this.uploader.parseRequest(request);
            for (FileItem fileItem : fileItemsList) {
                try {
                    NodeInterface node = StructrApp.getInstance().getNodeById(uuid);
                    if (node == null) {
                        response.setStatus(404);
                        response.getOutputStream().write("ERROR (404): File not found.\n".getBytes("UTF-8"));
                    }
                    if (!(node instanceof AbstractFile)) continue;
                    org.structr.dynamic.File file = (org.structr.dynamic.File)node;
                    if (file.isGranted(Permission.write, securityContext)) {
                        FileHelper.writeToFile(file, fileItem.getInputStream());
                        file.increaseVersion();
                        file.notifyUploadCompletion();
                        continue;
                    }
                    response.setStatus(403);
                    response.getOutputStream().write("ERROR (403): Write access forbidden.\n".getBytes("UTF-8"));
                }
                catch (IOException ex) {
                    logger.warn("Could not write to file", (Throwable)ex);
                }
            }
            tx.success();
        }
        catch (IOException | FileUploadException | FrameworkException t) {
            logger.error("Exception while processing request", t);
            UiAuthenticator.writeInternalServerError(response);
        }
    }

    private String errorPage(Throwable t) {
        return "<html><head><title>Error in Upload</title></head><body><h1>Error in Upload</h1><p>" + t.toString() + "</p>\n<!--" + ExceptionUtils.getStackTrace((Throwable)t) + "--></body></html>";
    }
}

