/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.Widget;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.message.WebSocketMessage;

public abstract class AbstractCommand {
    public static final String COMMAND_KEY = "command";
    public static final String ID_KEY = "id";
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractCommand.class.getName());
    protected Session session = null;
    protected StructrWebSocket webSocket = null;
    protected String callback = null;

    public abstract void processMessage(WebSocketMessage var1) throws FrameworkException;

    public abstract String getCommand();

    public Session getSession() {
        return this.session;
    }

    public StructrWebSocket getWebSocket() {
        return this.webSocket;
    }

    public Page getPage(String id) {
        AbstractNode node = this.getNode(id);
        if (node != null && node instanceof Page) {
            return (Page)node;
        }
        return null;
    }

    public DOMNode getDOMNode(String id) {
        AbstractNode node = this.getNode(id);
        if (node != null && node instanceof DOMNode) {
            return (DOMNode)node;
        }
        return null;
    }

    public Widget getWidget(String id) {
        AbstractNode node = this.getNode(id);
        if (node != null && node instanceof Widget) {
            return (Widget)node;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GraphObject getGraphObject(String id) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        try (Tx tx = app.tx();){
            GraphObject graphObject2 = app.get(id);
            tx.success();
            GraphObject graphObject = graphObject2;
            return graphObject;
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to get graph object", (Throwable)fex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractNode getNode(String id) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        try (Tx tx = app.tx();){
            AbstractNode node = (AbstractNode)app.getNodeById(id);
            tx.success();
            AbstractNode abstractNode = node;
            return abstractNode;
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to get node", (Throwable)fex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractRelationship getRelationship(String id) {
        if (id == null) {
            return null;
        }
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        try (Tx tx = app.tx();){
            AbstractRelationship rel = (AbstractRelationship)app.getRelationshipById(id);
            tx.success();
            AbstractRelationship abstractRelationship = rel;
            return abstractRelationship;
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to get relationship", (Throwable)fex);
            return null;
        }
    }

    public boolean requiresEnclosingTransaction() {
        return true;
    }

    protected void moveChildNodes(DOMNode sourceNode, DOMNode targetNode) {
        DOMNode child = (DOMNode)sourceNode.getFirstChild();
        while (child != null) {
            DOMNode next = (DOMNode)child.getNextSibling();
            targetNode.appendChild(child);
            child = next;
        }
    }

    public static ShadowDocument getOrCreateHiddenDocument() throws FrameworkException {
        App app = StructrApp.getInstance();
        ShadowDocument doc = (ShadowDocument)app.nodeQuery(ShadowDocument.class).includeDeletedAndHidden().getFirst();
        if (doc == null) {
            PropertyMap properties = new PropertyMap();
            properties.put((PropertyKey)AbstractNode.type, (Object)ShadowDocument.class.getSimpleName());
            properties.put((PropertyKey)AbstractNode.name, (Object)"__ShadowDocument__");
            properties.put((PropertyKey)AbstractNode.hidden, (Object)true);
            properties.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)true);
            doc = (ShadowDocument)app.create(ShadowDocument.class, properties);
        }
        return doc;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setWebSocket(StructrWebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }
}

