/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.web.entity.Widget;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class AppendWidgetCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)AppendWidgetCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String pageId = webSocketData.getPageId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        String baseUrl = (String)nodeData.get("widgetHostBaseUrl");
        boolean processDeploymentInfo = (Boolean)nodeData.get("processDeploymentInfo");
        if (parentId == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot add node without parentId").build(), true);
            return;
        }
        AbstractNode parentNode = this.getNode(parentId);
        if (parentNode == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
            return;
        }
        if (parentNode instanceof DOMNode) {
            DOMNode parentDOMNode = this.getDOMNode(parentId);
            if (parentDOMNode == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Parent node is no DOM node").build(), true);
                return;
            }
            Page page = this.getPage(pageId);
            if (page != null) {
                try {
                    Widget.expandWidget(this.getWebSocket().getSecurityContext(), page, parentDOMNode, baseUrl, nodeData, processDeploymentInfo);
                }
                catch (FrameworkException fex) {
                    logger.warn(fex.toString());
                    this.getWebSocket().send(MessageBuilder.status().code(422).message(fex.toString()).build(), true);
                }
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot use given node, not instance of DOMNode").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "APPEND_WIDGET";
    }

    static {
        StructrWebSocket.addCommand(AppendWidgetCommand.class);
    }
}

