/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.LinkedList;
import org.structr.api.graph.Direction;
import org.structr.api.graph.RelationshipType;
import org.structr.core.Adapter;
import org.structr.core.IterableAdapter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.RelationshipInterface;
import org.structr.web.common.RelType;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.WebSocketMessage;

public class ChildrenCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        RelationshipFactory factory = new RelationshipFactory(this.getWebSocket().getSecurityContext());
        AbstractNode node = this.getNode(webSocketData.getId());
        if (node == null) {
            return;
        }
        IterableAdapter rels = new IterableAdapter(node.getNode().getRelationships(Direction.OUTGOING, (RelationshipType)RelType.CONTAINS), (Adapter)factory);
        LinkedList<NodeInterface> result = new LinkedList<NodeInterface>();
        for (RelationshipInterface rel : rels) {
            NodeInterface endNode = rel.getTargetNode();
            if (endNode == null) continue;
            result.add(endNode);
        }
        webSocketData.setView("ui");
        webSocketData.setResult(result);
        this.getWebSocket().send(webSocketData, true);
    }

    @Override
    public String getCommand() {
        return "CHILDREN";
    }

    static {
        StructrWebSocket.addCommand(ChildrenCommand.class);
    }
}

