/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.VersionHelper;
import org.structr.console.Console;
import org.structr.console.tabcompletion.TabCompletionResult;
import org.structr.util.Writable;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ConsoleCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ConsoleCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String sessionId = webSocketData.getSessionId();
        logger.debug("CONSOLE received from session {}", (Object)sessionId);
        String line = (String)webSocketData.getNodeData().get("line");
        Boolean completion = (Boolean)webSocketData.getNodeData().get("completion");
        Console console = this.getWebSocket().getConsole();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWritable writeable = new OutputStreamWritable((OutputStream)out);
        try {
            if (Boolean.TRUE.equals(completion)) {
                List<TabCompletionResult> tabCompletionResult = console.getTabCompletion(line);
                JsonArray commands = new JsonArray();
                for (TabCompletionResult res : tabCompletionResult) {
                    commands.add((JsonElement)new JsonPrimitive(res.getCommand()));
                }
                this.getWebSocket().send(MessageBuilder.forName(this.getCommand()).callback(webSocketData.getCallback()).data("commands", commands).data("prompt", console.getPrompt()).data("mode", console.getMode()).data("versionInfo", VersionHelper.getFullVersionInfo()).message(out.toString("UTF-8")).build(), true);
            } else {
                console.run(line, writeable);
                this.getWebSocket().send(MessageBuilder.forName(this.getCommand()).callback(webSocketData.getCallback()).data("prompt", console.getPrompt()).data("mode", console.getMode()).data("versionInfo", VersionHelper.getFullVersionInfo()).message(out.toString("UTF-8")).build(), true);
            }
        }
        catch (Exception ex) {
            logger.debug("Error while executing console line {}", (Object)line, (Object)ex);
            this.getWebSocket().send(MessageBuilder.forName(this.getCommand()).callback(webSocketData.getCallback()).data("mode", console.getMode()).data("versionInfo", VersionHelper.getFullVersionInfo()).message(ex.getMessage()).build(), true);
        }
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public String getCommand() {
        return "CONSOLE";
    }

    static {
        StructrWebSocket.addCommand(ConsoleCommand.class);
    }

    private static class OutputStreamWritable
    implements Writable {
        private Writer writer = null;

        public OutputStreamWritable(OutputStream out) {
            this.writer = new OutputStreamWriter(out);
        }

        public void print(Object ... text) throws IOException {
            if (text != null) {
                for (Object o : text) {
                    if (o != null) {
                        this.writer.write(o.toString().replaceAll("\n", "\r\n"));
                        continue;
                    }
                    this.writer.write("null");
                }
            }
            this.writer.flush();
        }

        public void println(Object ... text) throws IOException {
            this.print(text);
            this.println();
            this.writer.flush();
        }

        public void println() throws IOException {
            this.writer.write(10);
            this.writer.write(13);
        }

        public void flush() throws IOException {
            this.writer.flush();
        }
    }
}

