/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.Template;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class CreateComponentCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String id = webSocketData.getId();
        if (id != null) {
            DOMNode node = this.getDOMNode(id);
            try {
                DOMNode clonedNode = this.create(node);
                TransactionCommand.registerNodeCallback((NodeInterface)clonedNode, (String)this.callback);
            }
            catch (FrameworkException | DOMException ex) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message(ex.getMessage()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node without id").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CREATE_COMPONENT";
    }

    public DOMNode create(DOMNode node) throws FrameworkException {
        DOMNode clonedNode = (DOMNode)node.cloneNode(false);
        if (!(clonedNode instanceof Template)) {
            this.moveChildNodes(node, clonedNode);
        }
        ShadowDocument hiddenDoc = CreateComponentCommand.getOrCreateHiddenDocument();
        clonedNode.setProperties(clonedNode.getSecurityContext(), new PropertyMap(DOMNode.ownerDocument, (Object)hiddenDoc));
        for (DOMNode child : DOMNode.getAllChildNodes(clonedNode)) {
            child.setProperties(child.getSecurityContext(), new PropertyMap(DOMNode.ownerDocument, (Object)hiddenDoc));
        }
        node.setProperties(node.getSecurityContext(), new PropertyMap(DOMNode.sharedComponent, (Object)clonedNode));
        return clonedNode;
    }

    static {
        StructrWebSocket.addCommand(CreateComponentCommand.class);
    }
}

