/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Arrays;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Relation;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class CreateRelationshipCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Map<String, Object> properties = webSocketData.getRelData();
        String sourceId = (String)properties.get("sourceId");
        String targetId = (String)properties.get("targetId");
        String relType = (String)properties.get("relType");
        AbstractNode sourceNode = this.getNode(sourceId);
        AbstractNode targetNode = this.getNode(targetId);
        if (sourceNode != null && targetNode != null) {
            SecurityContext securityContext = this.getWebSocket().getSecurityContext();
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            try {
                Class relationClass = StructrApp.getConfiguration().getRelationClassForCombinedType(sourceNode.getType(), relType, targetNode.getType());
                Relation rel = app.create((NodeInterface)sourceNode, (NodeInterface)targetNode, relationClass);
                TransactionCommand.registerRelCallback((RelationshipInterface)rel, (String)this.callback);
                if (rel != null) {
                    webSocketData.setResult(Arrays.asList(rel));
                    this.getWebSocket().send(webSocketData, true);
                }
            }
            catch (FrameworkException t) {
                this.getWebSocket().send(MessageBuilder.status().code(400).message(t.getMessage()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(400).message("The CREATE_RELATIONSHIP command needs source and target!").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CREATE_RELATIONSHIP";
    }

    static {
        StructrWebSocket.addCommand(CreateRelationshipCommand.class);
    }
}

