/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Favoritable;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.User;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.command.LayoutsCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class FavoritesCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)LayoutsCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Map<String, Object> data = webSocketData.getNodeData();
        String mode = (String)data.get("mode");
        String favoritableId = (String)data.get("id");
        Principal currentUser = this.webSocket.getCurrentUser();
        if (mode == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Favorites Command: No mode given. Valid modes: add, remove").build(), true);
        } else if (favoritableId == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Favorites Command: No favoritable id given").build(), true);
        } else {
            App app = StructrApp.getInstance((SecurityContext)this.webSocket.getSecurityContext());
            try (Tx tx = app.tx();){
                GraphObject file = app.get(favoritableId);
                if (file != null && file instanceof Favoritable) {
                    switch (mode) {
                        case "add": {
                            List favorites = (List)currentUser.getProperty(User.favorites);
                            favorites.add((Favoritable)file);
                            currentUser.setProperties(currentUser.getSecurityContext(), new PropertyMap(User.favorites, (Object)favorites));
                            this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).build(), true);
                            break;
                        }
                        case "remove": {
                            List favorites = (List)currentUser.getProperty(User.favorites);
                            favorites.remove((Favoritable)file);
                            currentUser.setProperties(currentUser.getSecurityContext(), new PropertyMap(User.favorites, (Object)favorites));
                            this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).build(), true);
                            break;
                        }
                        default: {
                            this.getWebSocket().send(MessageBuilder.status().code(422).message("Favorites Command: Invalid mode '" + mode + "'. Valid modes: add, remove").build(), true);
                            break;
                        }
                    }
                } else {
                    this.getWebSocket().send(MessageBuilder.status().code(422).message("Favorites Command: Favoritable with id '" + favoritableId + "'does not exist!").build(), true);
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Favorites Command: Favoritable with id '" + favoritableId + "'does not exist!").build(), true);
            }
        }
    }

    @Override
    public String getCommand() {
        return "FAVORITES";
    }

    static {
        StructrWebSocket.addCommand(FavoritesCommand.class);
    }
}

