/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;

public class FileUploadHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)FileUploadHandler.class.getName());
    private FileBase file = null;
    private FileChannel privateFileChannel = null;
    private Long size = 0L;

    public FileUploadHandler(FileBase file) {
        this.size = (Long)file.getProperty((PropertyKey)org.structr.dynamic.File.size);
        this.file = file;
        if (this.size == null) {
            try {
                FileChannel channel = this.getChannel(false);
                this.size = channel.size();
                this.updateSize(this.size);
            }
            catch (IOException ex) {
                logger.error("Could not access file", (Throwable)ex);
            }
        }
    }

    public void handleChunk(int sequenceNumber, int chunkSize, byte[] data, int chunks) throws IOException {
        FileChannel channel = this.getChannel(sequenceNumber > 0);
        if (channel != null) {
            channel.position(sequenceNumber * chunkSize);
            channel.write(ByteBuffer.wrap(data));
            if (this.size == null) {
                this.size = channel.size();
            }
            if (sequenceNumber + 1 == chunks) {
                this.finish();
                this.updateSize(this.size);
            }
        }
    }

    private void updateSize(Long size) {
        if (size == null) {
            return;
        }
        try {
            this.file.unlockSystemPropertiesOnce();
            this.file.setProperties(this.file.getSecurityContext(), new PropertyMap((PropertyKey)org.structr.dynamic.File.size, (Object)size));
        }
        catch (FrameworkException ex) {
            logger.warn("Could not set size to " + size, (Throwable)ex);
        }
    }

    public void finish() {
        try {
            FileChannel channel = this.getChannel(false);
            if (channel != null && channel.isOpen()) {
                channel.force(true);
                channel.close();
                this.privateFileChannel = null;
                this.file.notifyUploadCompletion();
            }
        }
        catch (IOException e) {
            logger.warn("Unable to finish file upload", (Throwable)e);
        }
    }

    private FileChannel getChannel(boolean append) throws IOException {
        String relativeFilePath;
        if (this.privateFileChannel == null && (relativeFilePath = this.file.getRelativeFilePath()) != null) {
            if (relativeFilePath.contains("..")) {
                throw new IOException("Security violation: File path contains ..");
            }
            String filePath = FileHelper.getFilePath(relativeFilePath);
            File fileOnDisk = new File(filePath);
            fileOnDisk.getParentFile().mkdirs();
            this.privateFileChannel = new FileOutputStream(fileOnDisk, append).getChannel();
        }
        return this.privateFileChannel;
    }
}

