/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.rest.resource.SchemaResource;
import org.structr.rest.resource.SchemaTypeResource;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class GetSchemaInfoCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)GetSchemaInfoCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        try {
            String type = (String)webSocketData.getNodeData().get("type");
            if (type != null) {
                Class typeClass = StructrApp.getConfiguration().getNodeEntityClass(type);
                webSocketData.setResult(SchemaTypeResource.getSchemaTypeResult(this.getWebSocket().getSecurityContext(), typeClass, "ui").getResults());
            } else {
                webSocketData.setResult(SchemaResource.getSchemaOverviewResult().getResults());
            }
            this.getWebSocket().send(webSocketData, true);
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
            this.getWebSocket().send(MessageBuilder.status().code(500).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "GET_SCHEMA_INFO";
    }

    static {
        StructrWebSocket.addCommand(GetSchemaInfoCommand.class);
    }
}

