/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.SchemaNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class GetTypeInfoCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)GetTypeInfoCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String type = (String)webSocketData.getNodeData().get("type");
        if (type == null) {
            logger.warn("Node type given not found");
            this.getWebSocket().send(MessageBuilder.status().code(400).build(), true);
        }
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        try {
            SchemaNode typeNode = (SchemaNode)app.nodeQuery(SchemaNode.class).andName(type).getFirst();
            if (typeNode != null) {
                webSocketData.setResult(Arrays.asList(typeNode));
                this.getWebSocket().send(webSocketData, true);
            }
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
            this.getWebSocket().send(MessageBuilder.status().code(500).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "GET_TYPE_INFO";
    }

    static {
        StructrWebSocket.addCommand(GetTypeInfoCommand.class);
    }
}

