/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.web.importer.Importer;
import org.structr.web.maintenance.deploy.DeploymentCommentHandler;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ImportCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ImportCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        Map<String, Object> properties = webSocketData.getNodeData();
        String code = (String)properties.get("code");
        String address = (String)properties.get("address");
        String name = (String)properties.get("name");
        boolean publicVisible = (Boolean)properties.get("publicVisible");
        boolean authVisible = (Boolean)properties.get("authVisible");
        boolean processDeploymentInfo = (Boolean)properties.get("processDeploymentInfo");
        try {
            boolean parseOk;
            Importer pageImporter = new Importer(securityContext, code, address, name, publicVisible, authVisible);
            if (processDeploymentInfo) {
                pageImporter.setIsDeployment(true);
                pageImporter.setCommentHandler(new DeploymentCommentHandler());
            }
            if (parseOk = pageImporter.parse()) {
                if (address != null) {
                    logger.info("Successfully parsed {}", (Object)address);
                    this.getWebSocket().send(MessageBuilder.status().code(200).message("Successfully parsed address " + address).build(), true);
                }
                String pageId = pageImporter.readPage().getUuid();
                HashMap<String, Object> resultData = new HashMap<String, Object>();
                if (pageId != null) {
                    resultData.put("id", pageId);
                    this.getWebSocket().send(MessageBuilder.status().code(200).message("Successfully created page " + name).data(resultData).build(), true);
                    pageImporter.importDataComments();
                } else {
                    this.getWebSocket().send(MessageBuilder.status().code(400).message("Error while creating page " + name).data(resultData).build(), true);
                }
            }
        }
        catch (FrameworkException fex) {
            logger.warn("Error while importing content", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "IMPORT";
    }

    static {
        StructrWebSocket.addCommand(ImportCommand.class);
    }
}

