/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.relationship.DOMChildren;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class InsertCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)InsertCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        Map<String, Object> properties = webSocketData.getNodeData();
        String parentId = (String)properties.get("id");
        Map<String, Object> relData = webSocketData.getRelData();
        if (parentId != null) {
            DOMNode parentNode = (DOMNode)this.getNode(parentId);
            DOMNode nodeToInsert = null;
            try {
                PropertyMap nodeProperties = PropertyMap.inputTypeToJavaType((SecurityContext)securityContext, properties);
                nodeToInsert = (DOMNode)app.create(DOMNode.class, nodeProperties);
            }
            catch (FrameworkException fex) {
                logger.warn("Could not create node.", (Throwable)fex);
                this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
            }
            if (nodeToInsert != null && parentNode != null) {
                try {
                    PropertyMap relProperties = PropertyMap.inputTypeToJavaType((SecurityContext)securityContext, relData);
                    app.create((NodeInterface)parentNode, (NodeInterface)nodeToInsert, DOMChildren.class, relProperties);
                }
                catch (FrameworkException t) {
                    this.getWebSocket().send(MessageBuilder.status().code(400).message(t.getMessage()).build(), true);
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(404).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(400).message("Insertion of new node failed.").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "INSERT";
    }
}

