/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.LinkSource;
import org.structr.web.entity.Linkable;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class LinkCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String sourceId = webSocketData.getId();
        Map<String, Object> properties = webSocketData.getNodeData();
        String targetId = (String)properties.get("targetId");
        LinkSource sourceNode = (LinkSource)this.getNode(sourceId);
        Linkable targetNode = (Linkable)this.getNode(targetId);
        if (sourceNode != null && targetNode != null) {
            try {
                sourceNode.setProperties(sourceNode.getSecurityContext(), new PropertyMap(LinkSource.linkable, (Object)targetNode));
            }
            catch (FrameworkException t) {
                this.getWebSocket().send(MessageBuilder.status().code(400).message(t.getMessage()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(400).message("The LINK command needs id and targetId!").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "LINK";
    }

    static {
        StructrWebSocket.addCommand(LinkCommand.class);
    }
}

