/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.structr.common.error.FrameworkException;
import org.structr.core.entity.Principal;
import org.structr.rest.auth.AuthHelper;
import org.structr.rest.auth.SessionHelper;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class LogoutCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) throws FrameworkException {
        Principal user = this.getWebSocket().getCurrentUser();
        if (user != null) {
            String sessionId = webSocketData.getSessionId();
            if (sessionId != null) {
                SessionHelper.clearSession(sessionId);
                SessionHelper.invalidateSession(SessionHelper.getSessionBySessionId(sessionId));
            }
            AuthHelper.sendLogoutNotification(user);
            this.getWebSocket().setAuthenticated(null, null);
            this.getWebSocket().send(MessageBuilder.status().code(401).build(), true);
            this.getWebSocket().invalidateConsole();
        }
    }

    @Override
    public String getCommand() {
        return "LOGOUT";
    }

    static {
        StructrWebSocket.addCommand(LogoutCommand.class);
    }
}

