/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class RemoveFromCollectionCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)RemoveFromCollectionCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        block11: {
            AbstractNode obj;
            String idToRemove;
            String keyString = (String)webSocketData.getNodeData().get("key");
            if (keyString == null) {
                logger.error("Unable to remove given object from collection: key is null");
                this.getWebSocket().send(MessageBuilder.status().code(400).build(), true);
            }
            if ((idToRemove = (String)webSocketData.getNodeData().get("idToRemove")) == null) {
                logger.error("Unable to remove given object from collection: idToRemove is null");
                this.getWebSocket().send(MessageBuilder.status().code(400).build(), true);
            }
            if ((obj = this.getNode(webSocketData.getId())) != null && !obj.isGranted(Permission.write, this.getWebSocket().getSecurityContext())) {
                this.getWebSocket().send(MessageBuilder.status().message("No write permission").code(400).build(), true);
                logger.warn("No write permission for {} on {}", new Object[]{this.getWebSocket().getCurrentUser().toString(), obj.toString()});
                return;
            }
            if (obj == null) {
                obj = this.getRelationship(webSocketData.getId());
            }
            AbstractNode objToRemove = this.getNode(idToRemove);
            if (obj != null && objToRemove != null) {
                try {
                    PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(obj.getClass(), keyString);
                    if (key == null) break block11;
                    List collection = (List)obj.getProperty(key);
                    collection.remove(objToRemove);
                    obj.setProperties(obj.getSecurityContext(), new PropertyMap(key, (Object)collection));
                    if (obj instanceof NodeInterface) {
                        TransactionCommand.registerNodeCallback((NodeInterface)((NodeInterface)obj), (String)this.callback);
                    } else if (obj instanceof RelationshipInterface) {
                        TransactionCommand.registerRelCallback((RelationshipInterface)((RelationshipInterface)obj), (String)this.callback);
                    }
                }
                catch (FrameworkException ex) {
                    logger.error("Unable to set properties: {}", (Object)ex.toString());
                    this.getWebSocket().send(MessageBuilder.status().code(400).build(), true);
                }
            } else {
                logger.warn("Graph object with uuid {} not found.", (Object)webSocketData.getId());
                this.getWebSocket().send(MessageBuilder.status().code(404).build(), true);
            }
        }
    }

    @Override
    public String getCommand() {
        return "REMOVE_FROM_COLLECTION";
    }

    static {
        StructrWebSocket.addCommand(RemoveFromCollectionCommand.class);
    }
}

