/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.relation.Sync;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class SyncModeCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        String sourceId = webSocketData.getId();
        Map<String, Object> properties = webSocketData.getNodeData();
        String targetId = (String)properties.get("targetId");
        String syncMode = (String)properties.get("syncMode");
        DOMNode sourceNode = (DOMNode)this.getNode(sourceId);
        DOMNode targetNode = (DOMNode)this.getNode(targetId);
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        if (sourceNode != null && targetNode != null) {
            try {
                app.create((NodeInterface)sourceNode, (NodeInterface)targetNode, Sync.class);
                if (syncMode.equals("bidir")) {
                    app.create((NodeInterface)targetNode, (NodeInterface)sourceNode, Sync.class);
                }
            }
            catch (Throwable t) {
                this.getWebSocket().send(MessageBuilder.status().code(400).message(t.getMessage()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(400).message("The SYNC_MODE command needs id and targetId!").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "SYNC_MODE";
    }

    static {
        StructrWebSocket.addCommand(SyncModeCommand.class);
    }
}

