/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.LinkedTreeNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyMap;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class UpdateCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)UpdateCommand.class.getName());
    private int count = 0;

    @Override
    public void processMessage(WebSocketMessage webSocketData) throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)this.getWebSocket().getSecurityContext());
        Boolean recValue = (Boolean)webSocketData.getNodeData().get("recursive");
        boolean rec = recValue != null ? recValue : false;
        GraphObject obj = this.getGraphObject(webSocketData.getId());
        if (obj == null) {
            logger.warn("Graph object with uuid {} not found.", (Object)webSocketData.getId());
            this.getWebSocket().send(MessageBuilder.status().code(404).build(), true);
            return;
        }
        webSocketData.getNodeData().remove("recursive");
        try (Tx tx = app.tx();){
            if (obj instanceof AbstractNode) {
                AbstractNode node = (AbstractNode)obj;
                if (!node.isGranted(Permission.write, this.getWebSocket().getSecurityContext())) {
                    this.getWebSocket().send(MessageBuilder.status().message("No write permission").code(400).build(), true);
                    logger.warn("No write permission for {} on {}", new Object[]{this.getWebSocket().getCurrentUser().toString(), obj.toString()});
                    tx.success();
                    return;
                }
                tx.success();
            }
        }
        LinkedHashSet<GraphObject> entities = new LinkedHashSet<GraphObject>();
        PropertyMap properties = null;
        try (Tx tx = app.tx();){
            this.collectEntities(entities, obj, null, rec);
            properties = PropertyMap.inputTypeToJavaType((SecurityContext)this.getWebSocket().getSecurityContext(), obj.getClass(), webSocketData.getNodeData());
            tx.success();
        }
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            this.count = 0;
            Tx tx = app.tx();
            Throwable throwable = null;
            try {
                while (iterator.hasNext() && this.count++ < 100) {
                    this.setProperties((GraphObject)iterator.next(), properties, true);
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public String getCommand() {
        return "UPDATE";
    }

    private void setProperties(GraphObject obj, PropertyMap properties, boolean rec) throws FrameworkException {
        obj.setProperties(obj.getSecurityContext(), properties);
        if (obj instanceof NodeInterface) {
            TransactionCommand.registerNodeCallback((NodeInterface)((NodeInterface)obj), (String)this.callback);
        } else if (obj instanceof RelationshipInterface) {
            TransactionCommand.registerRelCallback((RelationshipInterface)((RelationshipInterface)obj), (String)this.callback);
        }
    }

    private void collectEntities(Set<GraphObject> entities, GraphObject obj, PropertyMap properties, boolean rec) throws FrameworkException {
        entities.add(obj);
        if (rec && obj instanceof LinkedTreeNode) {
            LinkedTreeNode node = (LinkedTreeNode)obj;
            for (Object child : node.treeGetChildren()) {
                this.collectEntities(entities, (GraphObject)child, properties, rec);
            }
        }
    }

    static {
        StructrWebSocket.addCommand(UpdateCommand.class);
    }
}

