/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Setting;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.Property;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class WebappDataCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)WebappDataCommand.class.getName());
    private static final Property<List<String>> namesProperty = new GenericProperty("names");

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        block22: {
            block21: {
                Map<String, Object> data = webSocketData.getNodeData();
                String category = (String)data.get("category");
                String mode = (String)data.get("mode");
                String name = (String)data.get("name");
                if (mode == null) break block21;
                LinkedList<GraphObjectMap> result = new LinkedList<GraphObjectMap>();
                switch (mode) {
                    case "list": {
                        List<String> values = WebappDataCommand.listValues(category);
                        if (values != null) {
                            GraphObjectMap container = new GraphObjectMap();
                            container.put(namesProperty, values);
                            result.add(container);
                            webSocketData.setResult(result);
                            webSocketData.setRawResultCount(1);
                            this.getWebSocket().send(webSocketData, true);
                            break;
                        }
                        break block22;
                    }
                    case "get": {
                        try {
                            String content = new String(Files.readAllBytes(WebappDataCommand.locateFile(category, name).toPath()));
                            this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).data("value", content).build(), true);
                        }
                        catch (IOException | FrameworkException ex) {
                            logger.error("", ex);
                        }
                        break;
                    }
                    case "add": {
                        String positions = (String)data.get("value");
                        try {
                            File layoutFile = WebappDataCommand.locateFile(category, name);
                            if (layoutFile.exists()) {
                                this.getWebSocket().send(MessageBuilder.status().code(422).message("Category/name combination already exists!").build(), true);
                            } else {
                                this.createValue(category, name, positions);
                            }
                            this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).build(), true);
                        }
                        catch (FrameworkException ex) {
                            logger.error("", (Throwable)ex);
                        }
                        break;
                    }
                    case "delete": {
                        try {
                            this.deleteValue(category, name);
                            this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).build(), true);
                        }
                        catch (FrameworkException ex) {
                            logger.error("", (Throwable)ex);
                        }
                        break;
                    }
                    default: {
                        this.getWebSocket().send(MessageBuilder.status().code(422).message("Mode must be one of list, get, add or delete.").build(), true);
                        break;
                    }
                }
                break block22;
            }
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Mode must be one of list, get, add or delete.").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "WEBAPPDATA";
    }

    private void createValue(String category, String name, String value) throws FrameworkException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            File layoutFile = WebappDataCommand.locateFile(category, name);
            try (FileWriter writer = new FileWriter(layoutFile);){
                ((Writer)writer).append(value);
                ((Writer)writer).append("\n");
                ((Writer)writer).flush();
            }
            tx.success();
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void deleteValue(String category, String fileName) throws FrameworkException {
        if (fileName == null) {
            throw new FrameworkException(422, "Please supply category/name to delete.");
        }
        File layoutFile = WebappDataCommand.locateFile(category, fileName);
        layoutFile.delete();
    }

    public static List<String> listValues(String category) {
        String[] names;
        File baseDir = new File(Paths.get(WebappDataCommand.getValuesPath(), category).toString());
        LinkedList<String> fileNames = new LinkedList<String>();
        if (baseDir.exists() && (names = baseDir.list()) != null) {
            fileNames.addAll(Arrays.asList(names));
        }
        Collections.sort(fileNames, String.CASE_INSENSITIVE_ORDER);
        return fileNames;
    }

    public static File locateFile(String category, String name) throws FrameworkException {
        String finalCategory = StringUtils.isBlank((CharSequence)category) ? "defaultCategory" : category;
        String finalName = StringUtils.isBlank((CharSequence)name) ? "defaultName" : name;
        Path path = Paths.get(WebappDataCommand.getValuesPath(), category, name);
        WebappDataCommand.assertValidFileName(finalCategory, finalName);
        File file = new File(path.toString());
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return file;
    }

    public static void assertValidFileName(String category, String name) throws FrameworkException {
        boolean invalid = false;
        invalid |= File.separator.equals("/") && (category.contains(File.separator) || name.contains(File.separator));
        if (invalid |= File.separator.equals("\\") && (category.contains("/") || category.contains("\\") || name.contains("/") || name.contains("\\"))) {
            throw new FrameworkException(422, "Only relative file names are allowed, please use the " + Settings.WebDataPath.getKey() + " configuration setting to supply a custom path for web app data items.");
        }
    }

    public static String getValuesPath() {
        return Settings.getFullSettingPath((Setting)Settings.WebDataPath);
    }

    static {
        StructrWebSocket.addCommand(WebappDataCommand.class);
    }
}

