/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class WrapContentCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        String pageId = webSocketData.getPageId();
        nodeData.remove("parentId");
        if (pageId != null) {
            if (parentId == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot add node without parentId").build(), true);
                return;
            }
            DOMNode contentNode = this.getDOMNode(parentId);
            if (contentNode == null) {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
                return;
            }
            Page document = this.getPage(pageId);
            if (document != null) {
                String tagName = (String)nodeData.get("tagName");
                nodeData.remove("tagName");
                DOMNode parentNode = (DOMNode)contentNode.getParentNode();
                try {
                    DOMNode elementNode = null;
                    if (tagName != null && !tagName.isEmpty()) {
                        elementNode = (DOMNode)((Object)document.createElement(tagName));
                    }
                    if (elementNode != null) {
                        parentNode.appendChild(elementNode);
                    }
                    if (elementNode != null) {
                        elementNode.appendChild(contentNode);
                    }
                }
                catch (DOMException dex) {
                    this.getWebSocket().send(MessageBuilder.status().code(422).message(dex.getMessage()).build(), true);
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Page not found").build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot create node without pageId").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "WRAP_CONTENT";
    }

    static {
        StructrWebSocket.addCommand(WrapContentCommand.class);
    }
}

