/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command.dom;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Template;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class CreateAndAppendDOMNodeCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)CreateAndAppendDOMNodeCommand.class.getName());

    /*
     * Unable to fully structure code
     */
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        block30: {
            nodeData = webSocketData.getNodeData();
            parentId = (String)nodeData.get("parentId");
            childContent = (String)nodeData.get("childContent");
            pageId = webSocketData.getPageId();
            inheritVisibilityFlags = (Boolean)nodeData.get("inheritVisibilityFlags");
            if (inheritVisibilityFlags == null) {
                inheritVisibilityFlags = false;
            }
            nodeData.remove("parentId");
            nodeData.remove("inheritVisibilityFlags");
            if (pageId != null) {
                if (parentId == null) {
                    this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot add node without parentId").build(), true);
                    return;
                }
                parentNode = this.getDOMNode(parentId);
                if (parentNode == null) {
                    this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
                    return;
                }
                document = this.getPage(pageId);
                if (document != null) {
                    tagName = (String)nodeData.get("tagName");
                    nodeData.remove("tagName");
                    try {
                        if (tagName != null && "comment".equals(tagName)) {
                            newNode = (DOMNode)document.createComment("#comment");
                        } else if (tagName != null && "template".equals(tagName)) {
                            newNode = (DOMNode)document.createTextNode("#template");
                            try {
                                newNode.unlockSystemPropertiesOnce();
                                newNode.setProperties(newNode.getSecurityContext(), new PropertyMap((PropertyKey)NodeInterface.type, (Object)Template.class.getSimpleName()));
                            }
                            catch (FrameworkException fex) {
                                CreateAndAppendDOMNodeCommand.logger.warn("Unable to set type of node {} to Template: {}", new Object[]{newNode.getUuid(), fex.getMessage()});
                            }
                        } else if (tagName != null && !tagName.isEmpty()) {
                            if ("custom".equals(tagName)) {
                                try {
                                    newNode = (DOMElement)StructrApp.getInstance((SecurityContext)this.webSocket.getSecurityContext()).create(DOMElement.class, new NodeAttribute[]{new NodeAttribute(DOMElement.tag, (Object)"custom"), new NodeAttribute((PropertyKey)DOMElement.hideOnDetail, (Object)false), new NodeAttribute((PropertyKey)DOMElement.hideOnIndex, (Object)false)});
                                    if (newNode == null || document == null) ** GOTO lbl52
                                    newNode.doAdopt(document);
                                }
                                catch (FrameworkException fex) {
                                    this.getWebSocket().send(MessageBuilder.status().code(422).message(fex.getMessage()).build(), true);
                                    return;
                                }
                            } else {
                                newNode = (DOMNode)document.createElement(tagName);
                            }
                        } else {
                            newNode = (DOMNode)document.createTextNode("#text");
                        }
lbl52:
                        // 7 sources

                        newNode = this.getDOMNode(newNode.getUuid());
                        if (newNode == null) break block30;
                        parentNode.appendChild(newNode);
                        for (Map.Entry<String, Object> entry : nodeData.entrySet()) {
                            key = entry.getKey();
                            val = entry.getValue();
                            propertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(newNode.getClass(), key);
                            if (propertyKey == null) continue;
                            try {
                                convertedValue = val;
                                inputConverter = propertyKey.inputConverter(SecurityContext.getSuperUserInstance());
                                if (inputConverter != null) {
                                    convertedValue = inputConverter.convert(val);
                                }
                                newNode.setProperties(newNode.getSecurityContext(), new PropertyMap(propertyKey, convertedValue));
                            }
                            catch (FrameworkException fex) {
                                CreateAndAppendDOMNodeCommand.logger.warn("Unable to set node property {} of node {} to {}: {}", new Object[]{propertyKey, newNode.getUuid(), val, fex.getMessage()});
                            }
                        }
                        visibilityFlags = null;
                        if (inheritVisibilityFlags.booleanValue()) {
                            visibilityFlags = new PropertyMap();
                            visibilityFlags.put((PropertyKey)DOMNode.visibleToAuthenticatedUsers, parentNode.getProperty((PropertyKey)DOMNode.visibleToAuthenticatedUsers));
                            visibilityFlags.put((PropertyKey)DOMNode.visibleToPublicUsers, parentNode.getProperty((PropertyKey)DOMNode.visibleToPublicUsers));
                            try {
                                newNode.setProperties(newNode.getSecurityContext(), visibilityFlags);
                            }
                            catch (FrameworkException fex) {
                                CreateAndAppendDOMNodeCommand.logger.warn("Unable to inherit visibility flags for node {} from parent node {}", (Object)newNode, (Object)parentNode);
                            }
                        }
                        if (!StringUtils.isNotBlank((CharSequence)childContent)) break block30;
                        childNode = (DOMNode)document.createTextNode(childContent);
                        newNode.appendChild(childNode);
                        if (!inheritVisibilityFlags.booleanValue()) break block30;
                        try {
                            childNode.setProperties(childNode.getSecurityContext(), visibilityFlags);
                        }
                        catch (FrameworkException fex) {
                            CreateAndAppendDOMNodeCommand.logger.warn("Unable to inherit visibility flags for node {} from parent node {}", (Object)childNode, (Object)newNode);
                        }
                    }
                    catch (DOMException dex) {
                        this.getWebSocket().send(MessageBuilder.status().code(422).message(dex.getMessage()).build(), true);
                    }
                } else {
                    this.getWebSocket().send(MessageBuilder.status().code(404).message("Page not found").build(), true);
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot create node without pageId").build(), true);
            }
        }
    }

    @Override
    public String getCommand() {
        return "CREATE_AND_APPEND_DOM_NODE";
    }

    static {
        StructrWebSocket.addCommand(CreateAndAppendDOMNodeCommand.class);
    }
}

