/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command.dom;

import java.util.Map;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class CreateAndReplaceDOMNodeCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        String refId = (String)nodeData.get("refId");
        String pageId = webSocketData.getPageId();
        if (pageId != null) {
            if (parentId == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot add node without parentId").build(), true);
                return;
            }
            DOMNode parentNode = this.getDOMNode(parentId);
            if (parentNode == null) {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
                return;
            }
            if (refId == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot add node without refId").build(), true);
                return;
            }
            DOMNode refNode = this.getDOMNode(refId);
            if (refNode == null) {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Reference node not found").build(), true);
                return;
            }
            Page document = this.getPage(pageId);
            if (document != null) {
                String tagName = (String)nodeData.get("tagName");
                DOMNode newNode = null;
                try {
                    newNode = tagName != null && !tagName.isEmpty() ? (DOMNode)((Object)document.createElement(tagName)) : (DOMNode)((Object)document.createTextNode(""));
                    if (newNode != null) {
                        parentNode.replaceChild(newNode, refNode);
                    }
                }
                catch (DOMException dex) {
                    this.getWebSocket().send(MessageBuilder.status().code(422).message(dex.getMessage()).build(), true);
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Page not found").build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot create node without pageId").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CREATE_AND_REPLACE_DOM_NODE";
    }

    static {
        StructrWebSocket.addCommand(CreateAndReplaceDOMNodeCommand.class);
    }
}

