/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command.dom;

import java.util.LinkedList;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.WebSocketMessage;

public class DOMNodeChildrenCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        DOMNode node = this.getDOMNode(webSocketData.getId());
        if (node == null) {
            return;
        }
        LinkedList<DOMNode> result = new LinkedList<DOMNode>();
        for (DOMNode currentNode = (DOMNode)node.getFirstChild(); currentNode != null; currentNode = (DOMNode)currentNode.getNextSibling()) {
            result.add(currentNode);
        }
        webSocketData.setView("ui");
        webSocketData.setResult(result);
        this.getWebSocket().send(webSocketData, true);
    }

    @Override
    public String getCommand() {
        return "DOM_NODE_CHILDREN";
    }

    static {
        StructrWebSocket.addCommand(DOMNodeChildrenCommand.class);
    }
}

