/*
 * Decompiled with CFR 0.152.
 */
package org.structr.api.config;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Setting;
import org.structr.api.config.SettingsGroup;
import org.structr.api.util.html.Attr;
import org.structr.api.util.html.Tag;

public class BooleanSetting
extends Setting<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(BooleanSetting.class);

    public BooleanSetting(SettingsGroup settingsGroup, String string) {
        this(settingsGroup, string, null);
    }

    public BooleanSetting(SettingsGroup settingsGroup, String string, Boolean bl) {
        this(settingsGroup, (String)null, string, bl);
    }

    public BooleanSetting(SettingsGroup settingsGroup, String string, String string2, Boolean bl) {
        super(settingsGroup, string, string2, bl);
    }

    @Override
    public void render(Tag tag) {
        Tag tag2 = tag.block("div").css("form-group");
        tag2.block("label").text(this.getKey());
        Tag tag3 = tag2.empty("input").attr(new Attr("type", "radio"), new Attr("name", this.getKey()), new Attr("value", "true"));
        tag2.block("span").text("Enabled");
        Tag tag4 = tag2.empty("input").attr(new Attr("type", "radio"), new Attr("name", this.getKey()), new Attr("value", "false"));
        tag2.block("span").text("Disabled");
        if (((Boolean)this.getValue()).booleanValue()) {
            tag3.attr(new Attr("checked", "checked"));
        } else {
            tag4.attr(new Attr("checked", "checked"));
        }
        this.renderResetButton(tag2);
    }

    @Override
    public void fromString(String string) {
        if (string == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                this.setValue(Boolean.parseBoolean(string));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Invalid value for setting {0}: {1}, ignoring.", new Object[]{this.getKey(), string});
            }
        } else {
            this.setValue(false);
        }
    }
}

