/*
 * Decompiled with CFR 0.152.
 */
package org.structr.api.util;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractLinkedMap;
import org.apache.commons.collections4.map.LRUMap;
import org.structr.api.util.Cachable;

public class FixedSizeCache<K, V> {
    private Map<K, V> cache = null;

    public FixedSizeCache(int n) {
        this.cache = Collections.synchronizedMap(new InvalidatingLRUMap(n));
    }

    public synchronized void put(K k, V v) {
        this.cache.put(k, v);
    }

    public synchronized V get(K k) {
        return this.cache.get(k);
    }

    public synchronized void remove(K k) {
        this.cache.remove(k);
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized boolean isEmpty() {
        return this.cache.isEmpty();
    }

    private static class InvalidatingLRUMap<K, V>
    extends LRUMap<K, V> {
        public InvalidatingLRUMap(int n) {
            super(n, true);
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry<K, V> linkEntry) {
            Object object = linkEntry.getValue();
            if (object != null && object instanceof Cachable) {
                ((Cachable)object).onRemoveFromCache();
            }
            return true;
        }
    }
}

