/*
 * Decompiled with CFR 0.152.
 */
package org.structr.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.structr.api.Predicate;

public class Iterables {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, C extends Collection<T>> C addAll(C c, Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        try {
            while (iterator.hasNext()) {
                T t = iterator.next();
                if (t == null) continue;
                c.add(t);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception exception) {}
            }
        }
        return c;
    }

    public static long count(Iterable<?> iterable) {
        long l = 0L;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            ++l;
            iterator.next();
        }
        return l;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return !iterable.iterator().hasNext();
    }

    public static <X> Iterable<X> filter(Predicate<? super X> predicate, Iterable<X> iterable) {
        return new FilterIterable<X>(iterable, predicate);
    }

    public static <X> Iterator<X> filter(Predicate<? super X> predicate, Iterator<X> iterator) {
        return new FilterIterable.FilterIterator<X>(iterator, predicate);
    }

    public static <FROM, TO> Iterable<TO> map(Function<? super FROM, ? extends TO> function, Iterable<FROM> iterable) {
        return new MapIterable<FROM, TO>(iterable, function);
    }

    public static <FROM, TO> Iterator<TO> map(Function<? super FROM, ? extends TO> function, Iterator<FROM> iterator) {
        return new MapIterable.MapIterator<FROM, TO>(iterator, function);
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return Iterables.addAll(new ArrayList(), iterable);
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (t == null) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> Set<T> toSet(Iterable<T> iterable) {
        return Iterables.addAll(new HashSet(), iterable);
    }

    private static class FilterIterable<T>
    implements Iterable<T> {
        private final Predicate<? super T> specification;
        private final Iterable<T> iterable;

        public FilterIterable(Iterable<T> iterable, Predicate<? super T> predicate) {
            this.specification = predicate;
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilterIterator<T>(this.iterable.iterator(), this.specification);
        }

        static class FilterIterator<T>
        implements Iterator<T> {
            private final Predicate<? super T> specification;
            private final Iterator<T> iterator;
            private T currentValue;
            boolean finished = false;
            boolean nextConsumed = true;

            public FilterIterator(Iterator<T> iterator, Predicate<? super T> predicate) {
                this.specification = predicate;
                this.iterator = iterator;
            }

            public boolean moveToNextValid() {
                boolean bl = false;
                while (!bl && this.iterator.hasNext()) {
                    T t = this.iterator.next();
                    if (t == null || !this.specification.accept(t)) continue;
                    bl = true;
                    this.currentValue = t;
                    this.nextConsumed = false;
                }
                if (!bl) {
                    this.finished = true;
                }
                return bl;
            }

            @Override
            public T next() {
                if (!this.nextConsumed) {
                    this.nextConsumed = true;
                    return this.currentValue;
                }
                if (!this.finished && this.moveToNextValid()) {
                    this.nextConsumed = true;
                    return this.currentValue;
                }
                throw new NoSuchElementException("This iterator is exhausted.");
            }

            @Override
            public boolean hasNext() {
                return !this.finished && (!this.nextConsumed || this.moveToNextValid());
            }

            @Override
            public void remove() {
            }
        }
    }

    private static class MapIterable<FROM, TO>
    implements Iterable<TO> {
        private final Iterable<FROM> from;
        private final Function<? super FROM, ? extends TO> function;

        public MapIterable(Iterable<FROM> iterable, Function<? super FROM, ? extends TO> function) {
            this.from = iterable;
            this.function = function;
        }

        @Override
        public Iterator<TO> iterator() {
            return new MapIterator<FROM, TO>(this.from.iterator(), this.function);
        }

        static class MapIterator<FROM, TO>
        implements Iterator<TO> {
            private final Function<? super FROM, ? extends TO> function;
            private final Iterator<FROM> fromIterator;

            public MapIterator(Iterator<FROM> iterator, Function<? super FROM, ? extends TO> function) {
                this.fromIterator = iterator;
                this.function = function;
            }

            @Override
            public boolean hasNext() {
                return this.fromIterator.hasNext();
            }

            @Override
            public TO next() {
                FROM FROM = this.fromIterator.next();
                return this.function.apply(FROM);
            }

            @Override
            public void remove() {
                this.fromIterator.remove();
            }
        }
    }
}

