/*
 * Decompiled with CFR 0.152.
 */
package org.structr.geo;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.function.XmlFunction;
import org.structr.core.property.DoubleProperty;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportGPXFunction
extends Function<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger((String)ImportGPXFunction.class.getName());
    public static final Property<List<GraphObjectMap>> waypointsProperty = new GenericProperty("waypoints");
    public static final Property<List<GraphObjectMap>> routesProperty = new GenericProperty("routes");
    public static final Property<List<GraphObjectMap>> tracksProperty = new GenericProperty("tracks");
    public static final Property<List<GraphObjectMap>> segmentsProperty = new GenericProperty("segments");
    public static final Property<List<GraphObjectMap>> pointsProperty = new GenericProperty("points");
    public static final Property<GraphObjectMap> metadataProperty = new GenericProperty("metadata");
    public static final Property<GraphObjectMap> authorProperty = new GenericProperty("author");
    public static final Property<Double> latitudeProperty = new DoubleProperty("latitude");
    public static final Property<Double> longitudeProperty = new DoubleProperty("longitude");
    public static final String ERROR_MESSAGE = "";
    private static final Map<String, Property> fieldMapping = new LinkedHashMap<String, Property>();

    public Object apply(ActionContext actionContext, Object object, Object[] objectArray) throws FrameworkException {
        if (this.arrayHasLengthAndAllElementsNotNull(objectArray, 1)) {
            if (objectArray[0] instanceof String) {
                String string = (String)objectArray[0];
                if (string != null) {
                    GraphObjectMap graphObjectMap = new GraphObjectMap();
                    XmlFunction xmlFunction = new XmlFunction();
                    Document document = (Document)xmlFunction.apply(actionContext, object, objectArray);
                    LinkedList<GraphObjectMap> linkedList = new LinkedList<GraphObjectMap>();
                    LinkedList<GraphObjectMap> linkedList2 = new LinkedList<GraphObjectMap>();
                    LinkedList<GraphObjectMap> linkedList3 = new LinkedList<GraphObjectMap>();
                    if (document != null) {
                        Element element = document.getDocumentElement();
                        List<Element> list = this.getChildren(element);
                        for (Element element2 : list) {
                            switch (element2.getTagName()) {
                                case "metadata": {
                                    GraphObjectMap graphObjectMap2 = this.readPoint(element2);
                                    if (graphObjectMap2 == null) break;
                                    graphObjectMap.put(metadataProperty, (Object)graphObjectMap2);
                                    break;
                                }
                                case "rte": {
                                    this.readRoute(element2, linkedList2);
                                    break;
                                }
                                case "wpt": {
                                    this.readWaypoint(element2, linkedList);
                                    break;
                                }
                                case "trk": {
                                    this.readTrack(element2, linkedList3);
                                }
                            }
                        }
                        if (!linkedList.isEmpty()) {
                            graphObjectMap.put(waypointsProperty, linkedList);
                        }
                        if (!linkedList2.isEmpty()) {
                            graphObjectMap.put(routesProperty, linkedList2);
                        }
                        if (!linkedList3.isEmpty()) {
                            graphObjectMap.put(tracksProperty, linkedList3);
                        }
                    }
                    return graphObjectMap;
                }
            } else {
                logger.warn("Invalid parameter for GPX import, expected string, got {}", (Object)objectArray[0].getClass().getSimpleName());
            }
            return "Invalid parameters";
        }
        return this.usage(actionContext != null ? actionContext.isJavaScriptContext() : false);
    }

    public String usage(boolean bl) {
        return ERROR_MESSAGE;
    }

    public String shortDescription() {
        return "Imports a GPX file and creates a list of objects of a given type from it.";
    }

    public String getName() {
        return "import_gpx";
    }

    private void readWaypoint(Element element, List<GraphObjectMap> list) {
        GraphObjectMap graphObjectMap = this.readPoint(element);
        if (graphObjectMap != null) {
            list.add(graphObjectMap);
        }
    }

    private void readRoute(Element element, List<GraphObjectMap> list) {
        LinkedList<GraphObjectMap> linkedList = new LinkedList<GraphObjectMap>();
        GraphObjectMap graphObjectMap = new GraphObjectMap();
        for (Element element2 : this.getChildren(element)) {
            switch (element2.getTagName()) {
                case "rtept": {
                    GraphObjectMap graphObjectMap2 = this.readPoint(element2);
                    if (graphObjectMap2 == null) break;
                    linkedList.add(graphObjectMap2);
                }
            }
            this.readProperties(element2, graphObjectMap);
        }
        if (!linkedList.isEmpty()) {
            graphObjectMap.put(pointsProperty, linkedList);
        }
        list.add(graphObjectMap);
    }

    private void readTrack(Element element, List<GraphObjectMap> list) {
        LinkedList<GraphObjectMap> linkedList = new LinkedList<GraphObjectMap>();
        GraphObjectMap graphObjectMap = new GraphObjectMap();
        for (Element element2 : this.getChildren(element)) {
            switch (element2.getTagName()) {
                case "trkseg": {
                    this.readTrackSegment(element2, linkedList);
                }
            }
            this.readProperties(element2, graphObjectMap);
        }
        if (!linkedList.isEmpty()) {
            graphObjectMap.put(segmentsProperty, linkedList);
        }
        list.add(graphObjectMap);
    }

    private void readTrackSegment(Element element, List<GraphObjectMap> list) {
        LinkedList<GraphObjectMap> linkedList = new LinkedList<GraphObjectMap>();
        GraphObjectMap graphObjectMap = new GraphObjectMap();
        for (Element element2 : this.getChildren(element)) {
            switch (element2.getTagName()) {
                case "trkpt": {
                    GraphObjectMap graphObjectMap2 = this.readPoint(element2);
                    if (graphObjectMap2 == null) break;
                    linkedList.add(graphObjectMap2);
                }
            }
            this.readProperties(element2, graphObjectMap);
        }
        if (!linkedList.isEmpty()) {
            graphObjectMap.put(pointsProperty, linkedList);
        }
        list.add(graphObjectMap);
    }

    private GraphObjectMap readPoint(Element element) {
        Double d;
        GraphObjectMap graphObjectMap = new GraphObjectMap();
        Double d2 = this.getDoubleAttribute(element, "lat");
        if (d2 != null) {
            graphObjectMap.put(latitudeProperty, (Object)d2);
        }
        if ((d = this.getDoubleAttribute(element, "lon")) != null) {
            graphObjectMap.put(longitudeProperty, (Object)d);
        }
        for (Element element2 : this.getChildren(element)) {
            this.readProperties(element2, graphObjectMap);
        }
        return graphObjectMap;
    }

    private void readProperties(Element element, GraphObjectMap graphObjectMap) {
        GraphObjectMap graphObjectMap2;
        String string = element.getTagName();
        Property property = fieldMapping.get(string);
        if (property != null) {
            Class clazz = property.valueType();
            if (clazz != null) {
                switch (clazz.getSimpleName()) {
                    case "Double": {
                        this.storeDouble(element, graphObjectMap, (PropertyKey<Double>)property);
                        break;
                    }
                    case "String": {
                        this.storeString(element, graphObjectMap, (PropertyKey<String>)property);
                        break;
                    }
                    case "Integer": {
                        this.storeInt(element, graphObjectMap, (PropertyKey<Integer>)property);
                    }
                }
            }
        } else if ("author".equals(string) && !(graphObjectMap2 = this.readPoint(element)).isEmpty()) {
            graphObjectMap.put(authorProperty, (Object)graphObjectMap2);
        }
    }

    private List<Element> getChildren(Element element) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            linkedList.add((Element)node);
        }
        return linkedList;
    }

    private Double getDoubleAttribute(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2 != null && !string2.isEmpty()) {
            return Double.valueOf(string2);
        }
        return null;
    }

    private void storeDouble(Element element, GraphObjectMap graphObjectMap, PropertyKey<Double> propertyKey) {
        Double d;
        String string = element.getTextContent();
        if (string != null && !string.isEmpty() && (d = Double.valueOf(string)) != null) {
            graphObjectMap.put(propertyKey, (Object)d);
        }
    }

    private void storeInt(Element element, GraphObjectMap graphObjectMap, PropertyKey<Integer> propertyKey) {
        Integer n;
        String string = element.getTextContent();
        if (string != null && !string.isEmpty() && (n = Integer.valueOf(string)) != null) {
            graphObjectMap.put(propertyKey, (Object)n);
        }
    }

    private void storeString(Element element, GraphObjectMap graphObjectMap, PropertyKey<String> propertyKey) {
        String string = element.getTextContent();
        if (string != null && !string.isEmpty()) {
            graphObjectMap.put(propertyKey, (Object)string);
        }
    }

    static {
        fieldMapping.put("ele", (Property)new DoubleProperty("altitude"));
        fieldMapping.put("time", (Property)new StringProperty("time"));
        fieldMapping.put("name", (Property)new StringProperty("name"));
        fieldMapping.put("desc", (Property)new StringProperty("description"));
        fieldMapping.put("link", (Property)new StringProperty("link"));
        fieldMapping.put("src", (Property)new StringProperty("source"));
        fieldMapping.put("magvar", (Property)new DoubleProperty("magvar"));
        fieldMapping.put("cmt", (Property)new StringProperty("comment"));
        fieldMapping.put("type", (Property)new StringProperty("type"));
        fieldMapping.put("sym", (Property)new StringProperty("symbol"));
        fieldMapping.put("fix", (Property)new StringProperty("fixType"));
        fieldMapping.put("sat", (Property)new IntProperty("satelliteCount"));
        fieldMapping.put("hdop", (Property)new DoubleProperty("horizontalDilution"));
        fieldMapping.put("vdop", (Property)new DoubleProperty("verticalDilution"));
        fieldMapping.put("pdop", (Property)new DoubleProperty("positionDilution"));
        fieldMapping.put("ageofdgpsdata", (Property)new DoubleProperty("dgpsAge"));
        fieldMapping.put("dgpsid", (Property)new StringProperty("dgpsId"));
        fieldMapping.put("geoidheight", (Property)new DoubleProperty("geoidHeight"));
    }
}

