/*
 * Decompiled with CFR 0.152.
 */
package org.structr.geo;

import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.property.DoubleProperty;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class UTMToLatLonFunction
extends Function<Object, Object> {
    private static final String ERROR_MESSAGE = "Usage: ${utmToLatLon(latitude, longitude)}. Example: ${utmToLatLon('32U 395473 5686479')}";
    private static final Logger logger = LoggerFactory.getLogger((String)UTMToLatLonFunction.class.getName());
    private static final String UTMHemisphere = "SSSSSSSSSSNNNNNNNNNNN";
    private static final String UTMzdlChars = "CDEFGHJKLMNPQRSTUVWXX";
    public static final DoubleProperty latitudeProperty = new DoubleProperty("latitude");
    public static final DoubleProperty longitudeProperty = new DoubleProperty("longitude");

    public Object apply(ActionContext actionContext, Object object, Object[] objectArray) throws FrameworkException {
        if (this.arrayHasLengthAndAllElementsNotNull(objectArray, 1)) {
            String string = (String)objectArray[0];
            if (string != null) {
                String[] stringArray = string.split("[\\s]+");
                if (stringArray.length < 3) {
                    logger.warn("Unsupported UTM string: this implementation only supports the full UTM format with spaces, e.g. 32U 439596 5967780 or 32 N 439596 5967780.");
                } else {
                    if (stringArray.length == 3) {
                        String string2 = stringArray[0];
                        String string3 = stringArray[1];
                        String string4 = stringArray[2];
                        return this.utmToLatLon(string2, this.getHemisphereFromZone(string2), string3, string4);
                    }
                    if (stringArray.length == 4) {
                        String string5 = stringArray[0];
                        String string6 = stringArray[1];
                        String string7 = stringArray[2];
                        String string8 = stringArray[3];
                        return this.utmToLatLon(string5, string6, string7, string8);
                    }
                }
            } else {
                logger.warn("Invalid argument(s), cannot convert to double: {}, {}", new Object[]{objectArray[0], objectArray[1]});
            }
        }
        return "Unsupported UTM string";
    }

    public String usage(boolean bl) {
        return ERROR_MESSAGE;
    }

    public String shortDescription() {
        return "Converts the given latitude/longitude coordinates into an UTM string.";
    }

    public String getName() {
        return "utm_to_lat_lon";
    }

    private String getHemisphereFromZone(String string) {
        int n;
        String string2 = null;
        switch (string.length()) {
            case 3: {
                string2 = string.substring(2);
                break;
            }
            case 2: {
                if (!string.matches("\\d\\D")) break;
                string2 = string.substring(1);
            }
        }
        if (string2 != null && (n = UTMzdlChars.indexOf(string2)) >= 0) {
            return UTMHemisphere.substring(n, n + 1);
        }
        logger.warn("Unable to determine hemisphere from UTM zone, assuming NORTHERN hemisphere.");
        return "N";
    }

    private GraphObjectMap utmToLatLon(String string, String string2, String string3, String string4) {
        GraphObjectMap graphObjectMap = new GraphObjectMap();
        String string5 = string.replaceAll("[\\D]+", "");
        StringBuilder stringBuilder = new StringBuilder("EPSG:32");
        switch (string2) {
            case "N": {
                stringBuilder.append("6");
                break;
            }
            case "S": {
                stringBuilder.append("7");
            }
        }
        if (string5.length() == 1) {
            stringBuilder.append("0");
        }
        stringBuilder.append(string5);
        try {
            String string6 = CRS.decode((String)stringBuilder.toString());
            CoordinateReferenceSystem coordinateReferenceSystem = CRS.decode((String)"EPSG:4326");
            MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)string6, (CoordinateReferenceSystem)coordinateReferenceSystem, (boolean)true);
            DirectPosition2D directPosition2D = new DirectPosition2D(this.getDoubleOrNull(string3).doubleValue(), this.getDoubleOrNull(string4).doubleValue());
            DirectPosition directPosition = mathTransform.transform((DirectPosition)directPosition2D, null);
            graphObjectMap.put((PropertyKey)latitudeProperty, (Object)directPosition.getOrdinate(0));
            graphObjectMap.put((PropertyKey)longitudeProperty, (Object)directPosition.getOrdinate(1));
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
        }
        return graphObjectMap;
    }
}

