/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractIntHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveIntObjectHashMap<VALUE>
extends AbstractIntHopScotchCollection<VALUE>
implements PrimitiveIntObjectMap<VALUE> {
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveIntObjectHashMap(Table<VALUE> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public VALUE put(int key, VALUE value) {
        return HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, value, this);
    }

    @Override
    public boolean containsKey(int key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public VALUE get(int key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key);
    }

    @Override
    public VALUE remove(int key) {
        return HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key);
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    @Override
    public <E extends Exception> void visitEntries(PrimitiveIntObjectVisitor<VALUE, E> visitor) throws E {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            int key = (int)this.table.key(i);
            if ((long)key == nullKey || !visitor.visited(key, this.table.value(i))) continue;
            return;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.typeAndSizeEqual(other)) {
            PrimitiveIntObjectHashMap that = (PrimitiveIntObjectHashMap)other;
            IntObjEquality equality = new IntObjEquality(that);
            this.visitEntries(equality);
            return equality.isEqual();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeComputer hash = new HashCodeComputer();
        this.visitEntries(hash);
        return hash.hashCode();
    }

    private static class HashCodeComputer<T>
    implements PrimitiveIntObjectVisitor<T, RuntimeException> {
        private int hash = 1337;

        private HashCodeComputer() {
        }

        @Override
        public boolean visited(int key, T value) throws RuntimeException {
            this.hash += HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(key + value.hashCode());
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashCodeComputer that = (HashCodeComputer)o;
            return this.hash == that.hash;
        }
    }

    private static class IntObjEquality<T>
    implements PrimitiveIntObjectVisitor<T, RuntimeException> {
        private PrimitiveIntObjectHashMap other;
        private boolean equal = true;

        IntObjEquality(PrimitiveIntObjectHashMap that) {
            this.other = that;
        }

        @Override
        public boolean visited(int key, T value) {
            Object otherValue = this.other.get(key);
            this.equal = otherValue == value || otherValue != null && otherValue.equals(value);
            return !this.equal;
        }

        public boolean isEqual() {
            return this.equal;
        }
    }
}

