/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import org.jivesoftware.smack.ConnectionConfiguration;

public class XMPPTCPConnectionConfiguration
extends ConnectionConfiguration {
    public static int DEFAULT_CONNECT_TIMEOUT = 30000;
    private final boolean compressionEnabled;
    private final int connectTimeout;

    private XMPPTCPConnectionConfiguration(Builder builder) {
        super((ConnectionConfiguration.Builder)builder);
        this.compressionEnabled = builder.compressionEnabled;
        this.connectTimeout = builder.connectTimeout;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ConnectionConfiguration.Builder<Builder, XMPPTCPConnectionConfiguration> {
        private boolean compressionEnabled = false;
        private int connectTimeout = DEFAULT_CONNECT_TIMEOUT;

        private Builder() {
        }

        public Builder setCompressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        protected Builder getThis() {
            return this;
        }

        public XMPPTCPConnectionConfiguration build() {
            return new XMPPTCPConnectionConfiguration(this);
        }
    }
}

