/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ftplet.FtpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.CreateNodeCommand;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.dynamic.File;
import org.structr.files.ftp.AbstractStructrFtpFile;
import org.structr.files.ftp.StructrFtpUser;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public class FileOrFolder
extends AbstractStructrFtpFile {
    private static final Logger logger = LoggerFactory.getLogger((String)FileOrFolder.class.getName());

    public FileOrFolder(String newPath, StructrFtpUser user) {
        super(newPath, user);
    }

    public boolean isDirectory() {
        logger.error("isDirectory()");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isFile() {
        logger.error("isFile()");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getSize() {
        logger.error("getSize()");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream createInputStream(long l) throws IOException {
        logger.error("createInputStream()");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getPhysicalFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mkdir() {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            logger.info("mkdir() Folder");
            AbstractFile existing = FileHelper.getFileByAbsolutePath((SecurityContext)SecurityContext.getSuperUserInstance(), (String)this.newPath);
            if (existing != null) {
                logger.warn("File {} already exists.", (Object)this.newPath);
                boolean bl = false;
                return bl;
            }
            Folder parentFolder = (Folder)FileHelper.getFileByAbsolutePath((SecurityContext)this.securityContext, (String)StringUtils.substringBeforeLast((String)this.newPath, (String)"/"));
            try {
                Folder newFolder = (Folder)((CreateNodeCommand)app.command(CreateNodeCommand.class)).execute(new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.type, (Object)Folder.class.getSimpleName()), new NodeAttribute((PropertyKey)AbstractNode.owner, (Object)this.owner.getStructrUser()), new NodeAttribute((PropertyKey)AbstractNode.name, (Object)this.getName())});
                if (parentFolder != null) {
                    newFolder.setProperty((PropertyKey)AbstractFile.parent, (Object)parentFolder);
                }
            }
            catch (FrameworkException ex) {
                logger.error("", (Throwable)ex);
                boolean bl = false;
                if (tx == null) return bl;
                if (var3_4 == null) {
                    tx.close();
                    return bl;
                }
                try {
                    tx.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    var3_4.addSuppressed(throwable);
                    return bl;
                }
            }
            tx.success();
            boolean bl = true;
            return bl;
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
            return false;
        }
    }

    public List<FtpFile> listFiles() {
        logger.error("listFiles()");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OutputStream createOutputStream(long l) throws IOException {
        try (Tx tx = StructrApp.getInstance().tx();){
            if (this.structrFile == null) {
                Folder parentFolder = (Folder)FileHelper.getFileByAbsolutePath((SecurityContext)this.securityContext, (String)StringUtils.substringBeforeLast((String)this.newPath, (String)"/"));
                try {
                    this.structrFile = FileHelper.createFile((SecurityContext)this.securityContext, (byte[])new byte[0], null, File.class, (String)this.getName());
                    this.structrFile.setProperty((PropertyKey)AbstractNode.type, (Object)File.class.getSimpleName());
                    this.structrFile.setProperty((PropertyKey)AbstractNode.owner, (Object)this.owner.getStructrUser());
                    if (parentFolder != null) {
                        this.structrFile.setProperty((PropertyKey)AbstractFile.parent, (Object)parentFolder);
                    }
                }
                catch (FrameworkException ex) {
                    logger.error("", (Throwable)ex);
                    OutputStream outputStream = null;
                    if (tx == null) return outputStream;
                    if (throwable == null) {
                        tx.close();
                        return outputStream;
                    }
                    try {
                        tx.close();
                        return outputStream;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return outputStream;
                    }
                }
            }
            tx.success();
            FileOutputStream fileOutputStream = ((FileBase)this.structrFile).getOutputStream();
            return fileOutputStream;
        }
        catch (FrameworkException fex) {
            logger.error(null, (Throwable)fex);
            return null;
        }
    }
}

