/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.service.Command;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.files.ftp.StructrFileSystemFactory;
import org.structr.files.ftp.StructrUserManager;

public class FtpService
implements RunnableService {
    private static final Logger logger = LoggerFactory.getLogger((String)FtpService.class.getName());
    private boolean isRunning = false;
    private static int port;
    private FtpServer server;

    public void startService() throws Exception {
        FtpServerFactory serverFactory = new FtpServerFactory();
        serverFactory.setUserManager((UserManager)new StructrUserManager());
        serverFactory.setFileSystem((FileSystemFactory)new StructrFileSystemFactory());
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(port);
        serverFactory.addListener("default", factory.createListener());
        logger.info("Starting FTP server on port {}", new Object[]{String.valueOf(port)});
        this.server = serverFactory.createServer();
        this.server.start();
        this.isRunning = true;
    }

    public void stopService() {
        if (this.isRunning) {
            this.shutdown();
        }
    }

    public boolean runOnStartup() {
        return true;
    }

    public boolean isRunning() {
        return !this.server.isStopped();
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices services) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        port = (Integer)Settings.FtpPort.getValue();
    }

    public void initialized() {
    }

    public void shutdown() {
        if (!this.server.isStopped()) {
            this.server.stop();
            this.isRunning = false;
        }
    }

    public String getName() {
        return FtpServer.class.getSimpleName();
    }

    public boolean isVital() {
        return false;
    }

    public String getModuleName() {
        return "file-access";
    }
}

