/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.AccessMode;
import org.structr.common.PathHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractUser;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ftp.FileOrFolder;
import org.structr.files.ftp.FtpFilePageWrapper;
import org.structr.files.ftp.StructrFtpFile;
import org.structr.files.ftp.StructrFtpFolder;
import org.structr.files.ftp.StructrFtpUser;
import org.structr.rest.auth.AuthHelper;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.User;
import org.structr.web.entity.dom.Page;

public class StructrFileSystemView
implements FileSystemView {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFileSystemView.class.getName());
    private StructrFtpUser user = null;
    private SecurityContext securityContext = null;
    private String workingDir = "/";

    public StructrFileSystemView(org.apache.ftpserver.ftplet.User user) {
        try (Tx tx = StructrApp.getInstance().tx();){
            User structrUser = (User)AuthHelper.getPrincipalForCredential((PropertyKey)AbstractUser.name, (Object)user.getName());
            this.securityContext = SecurityContext.getInstance((Principal)structrUser, (AccessMode)AccessMode.Backend);
            this.user = new StructrFtpUser(this.securityContext, structrUser);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Error while initializing file system view", (Throwable)fex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FtpFile getHomeDirectory() throws FtpException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            User structrUser = (User)AuthHelper.getPrincipalForCredential((PropertyKey)AbstractUser.name, (Object)this.user.getName());
            Folder homeDir = (Folder)structrUser.getProperty((PropertyKey)User.homeDirectory);
            tx.success();
            StructrFtpFolder structrFtpFolder = new StructrFtpFolder(this.securityContext, homeDir);
            return structrFtpFolder;
        }
        catch (FrameworkException fex) {
            logger.error("Error while getting home directory", (Throwable)fex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FtpFile getWorkingDirectory() throws FtpException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            AbstractFile structrWorkingDir = FileHelper.getFileByAbsolutePath((SecurityContext)this.securityContext, (String)this.workingDir);
            tx.success();
            if (structrWorkingDir == null || structrWorkingDir instanceof FileBase) {
                StructrFtpFolder structrFtpFolder2 = new StructrFtpFolder(this.securityContext, null);
                return structrFtpFolder2;
            }
            StructrFtpFolder structrFtpFolder = new StructrFtpFolder(this.securityContext, (Folder)structrWorkingDir);
            return structrFtpFolder;
        }
        catch (FrameworkException fex) {
            logger.error("Error in changeWorkingDirectory()", (Throwable)fex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changeWorkingDirectory(String requestedPath) throws FtpException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            StructrFtpFolder newWorkingDirectory = (StructrFtpFolder)this.getFile(requestedPath);
            this.workingDir = newWorkingDirectory.getAbsolutePath();
            tx.success();
            boolean bl = true;
            return bl;
        }
        catch (FrameworkException fex) {
            logger.error("Error in changeWorkingDirectory()", (Throwable)fex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FtpFile getFile(String rawRequestedPath) throws FtpException {
        String requestedPath = rawRequestedPath;
        if (requestedPath.endsWith("/")) {
            requestedPath = requestedPath.substring(0, requestedPath.length() - 1);
        }
        logger.info("Requested path: {}, cleaned to {}", (Object)rawRequestedPath, (Object)requestedPath);
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            AbstractFile file;
            if (StringUtils.isBlank((CharSequence)requestedPath) || "/".equals(requestedPath)) {
                FtpFile ftpFile = this.getHomeDirectory();
                return ftpFile;
            }
            StructrFtpFolder cur = (StructrFtpFolder)this.getWorkingDirectory();
            if (".".equals(requestedPath) || "./".equals(requestedPath)) {
                StructrFtpFolder structrFtpFolder = cur;
                return structrFtpFolder;
            }
            if ("..".equals(requestedPath) || "../".equals(requestedPath)) {
                StructrFtpFolder structrFtpFolder = new StructrFtpFolder(this.securityContext, (Folder)cur.getStructrFile().getProperty((PropertyKey)AbstractFile.parent));
                return structrFtpFolder;
            }
            if (!requestedPath.startsWith("/")) {
                String basePath = cur.getAbsolutePath();
                logger.info("Base path: {}", (Object)basePath);
                while (requestedPath.startsWith("..")) {
                    requestedPath = StringUtils.stripStart((String)StringUtils.stripStart((String)requestedPath, (String)".."), (String)"/");
                    basePath = StringUtils.substringBeforeLast((String)basePath, (String)"/");
                }
                requestedPath = StringUtils.stripEnd((String)(basePath.equals("/") ? "/".concat(requestedPath) : basePath.concat("/").concat(requestedPath)), (String)"/");
                logger.info("Base path: {}, requestedPath: {}", new Object[]{basePath, requestedPath});
            }
            if ((file = FileHelper.getFileByAbsolutePath((SecurityContext)this.securityContext, (String)requestedPath)) != null) {
                if (file instanceof Folder) {
                    tx.success();
                    StructrFtpFolder structrFtpFolder = new StructrFtpFolder(this.securityContext, (Folder)file);
                    return structrFtpFolder;
                }
                tx.success();
                StructrFtpFile structrFtpFile = new StructrFtpFile(this.securityContext, (FileBase)file);
                return structrFtpFile;
            }
            Page page = (Page)StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery(Page.class).andName(PathHelper.getName((String)requestedPath)).getFirst();
            if (page != null) {
                tx.success();
                FtpFilePageWrapper ftpFilePageWrapper = new FtpFilePageWrapper(page);
                return ftpFilePageWrapper;
            }
            logger.warn("No existing file found: {}", (Object)requestedPath);
            tx.success();
            FileOrFolder fileOrFolder = new FileOrFolder(requestedPath, this.user);
            return fileOrFolder;
        }
        catch (FrameworkException fex) {
            logger.error("Error in getFile()", (Throwable)fex);
            return null;
        }
    }

    public boolean isRandomAccessible() throws FtpException {
        logger.info("isRandomAccessible(), returning true");
        return true;
    }

    public void dispose() {
        logger.info("dispose() does nothing");
    }
}

